/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lilypuree.hyle.Constants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.logging.log4j.Level;

public class BiomeInjector {
    public static void apply(BiomeSource source) {
        Suppliers.memoize(() -> FeatureSorter.m_220603_(source.m_207840_().stream().toList(), biomeHolder -> ((Biome)biomeHolder.get()).m_47536_().m_47818_(), (boolean)true));
    }

    public static void apply(RegistryAccess registryAccess) {
        Constants.LOG.log(Level.INFO, "Hyle stone replacer injection started.");
        long start = System.currentTimeMillis();
        Registry biomeRegistry = registryAccess.m_175515_(Registries.f_256952_);
        PlacedFeature STONE_REPLACER = (PlacedFeature)registryAccess.m_175515_(Registries.f_256988_).m_7745_(new ResourceLocation("hyle", "stone_replacer"));
        for (Biome biome : biomeRegistry) {
            BiomeInjector.addFeatureToBiome(biome, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, STONE_REPLACER);
        }
        long timeTook = System.currentTimeMillis() - start;
        Constants.LOG.log(Level.INFO, "Hyle stone replacer injection took {} ms to complete.", (Object)timeTook);
    }

    private static void addFeatureToBiome(Biome biome, GenerationStep.Decoration step, PlacedFeature placedFeature) {
        ArrayList<HolderSet.Direct> features = new ArrayList<HolderSet.Direct>(biome.m_47536_().m_47818_());
        while (features.size() <= step.ordinal()) {
            features.add(HolderSet.m_205809_((Holder[])new Holder[0]));
        }
        List list = ((HolderSet)features.get(step.ordinal())).m_203614_().collect(Collectors.toList());
        list.add(Holder.m_205709_((Object)placedFeature));
        features.set(step.ordinal(), HolderSet.m_205800_((List)ImmutableList.copyOf(list)));
        biome.m_47536_().f_47781_ = ImmutableList.copyOf(features);
    }
}

