/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.misc;

import commoble.databuddy.data.CodecJsonDataManager;
import java.util.Optional;
import lilypuree.hyle.Constants;
import lilypuree.hyle.misc.StoneTypeCodecJsonDataManager;
import lilypuree.hyle.world.feature.StoneRegion;
import lilypuree.hyle.world.feature.gen.StoneType;
import net.minecraft.resources.ResourceLocation;

public class HyleDataLoaders {
    public static CodecJsonDataManager<StoneType> STONE_TYPE_LOADER;
    public static final CodecJsonDataManager<StoneRegion> REGION_LOADER;

    public static void init(StoneTypeCodecJsonDataManager stoneTypeManager) {
        STONE_TYPE_LOADER = stoneTypeManager;
    }

    private static StoneType getStoneType(ResourceLocation rl) {
        return (StoneType)STONE_TYPE_LOADER.getData().get((Object)rl);
    }

    public static StoneType getStoneType(String name) {
        if (name.equals("")) {
            return StoneType.NO_REPLACE;
        }
        if (name.contains(":")) {
            return HyleDataLoaders.getStoneType(new ResourceLocation(name));
        }
        return HyleDataLoaders.getStoneType(new ResourceLocation("hyle", name));
    }

    public static String getNameForStoneType(StoneType state) {
        ResourceLocation key = (ResourceLocation)STONE_TYPE_LOADER.getData().inverse().get((Object)state);
        if (key != null) {
            return key.toString();
        }
        return null;
    }

    public static ResourceLocation getNameForRegion(StoneRegion region) {
        return (ResourceLocation)REGION_LOADER.getData().inverse().get((Object)region);
    }

    public static Optional<StoneRegion> getRegion(ResourceLocation name) {
        return REGION_LOADER.getData().containsKey((Object)name) ? Optional.of((StoneRegion)REGION_LOADER.getData().get((Object)name)) : Optional.empty();
    }

    static {
        REGION_LOADER = new CodecJsonDataManager<StoneRegion>("hyledata/regions", StoneRegion.CODEC, Constants.LOG);
    }
}

