/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lilypuree.hyle.world.feature.gen.StoneType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeBasedReplacer {
    public static final BiomeBasedReplacer NONE = new BiomeBasedReplacer(Collections.emptyList(), Collections.emptyList());
    public static final Codec<BiomeBasedReplacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_).listOf().fieldOf("biomes").forGetter(x -> x.biomes), (App)Strata.CODEC.listOf().fieldOf("stratum").forGetter(x -> x.stratas)).apply((Applicative)instance, BiomeBasedReplacer::new));
    private final List<ResourceKey<Biome>> biomes;
    private final List<Strata> stratas;
    private final int totalThickness;

    public BiomeBasedReplacer(List<ResourceKey<Biome>> biomes, List<Strata> stratas) {
        this.biomes = biomes;
        this.stratas = stratas;
        this.totalThickness = stratas.stream().map(Strata::thickness).reduce(Integer::sum).orElse(0);
    }

    public boolean apply(ResourceKey<Biome> biomeKey) {
        Set<ResourceKey<Biome>> set = Set.copyOf(this.biomes);
        return set.contains(biomeKey);
    }

    public int getTotalThickness() {
        return this.totalThickness;
    }

    public StoneType compute(int depth) {
        int combined = 0;
        for (Strata strata : this.stratas) {
            if (depth >= (combined += strata.thickness)) continue;
            return strata.type;
        }
        return null;
    }

    public record Strata(StoneType type, int thickness) {
        public static final Codec<Strata> CODEC = Codec.pair((Codec)StoneType.CODEC.fieldOf("stone_type").codec(), (Codec)Codec.intRange((int)0, (int)4096).fieldOf("thickness").codec()).xmap(pair -> new Strata((StoneType)pair.getFirst(), (Integer)pair.getSecond()), strata -> Pair.of((Object)strata.type, (Object)strata.thickness));
    }
}

