/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import lilypuree.hyle.world.feature.gen.PrimaryNoiseSampler;
import lilypuree.hyle.world.feature.gen.SecondaryNoiseSampler;
import lilypuree.hyle.world.feature.gen.StoneType;

public class StoneRegion {
    public static final Codec<StoneRegion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PrimaryNoiseSampler.Settings.CODEC.fieldOf("primary").forGetter(s -> s.primarySettings), (App)SecondaryNoiseSampler.Settings.CODEC.fieldOf("secondary").forGetter(s -> s.secondarySettings), (App)StoneType.CODEC.listOf().fieldOf("tertiary").forGetter(s -> s.tertiaries), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("tertiary_cutoff").forGetter(s -> Float.valueOf(s.tertiaryCutoff)), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("unconformity_cutoff").forGetter(s -> Float.valueOf(s.unconformityCutoff))).apply((Applicative)instance, StoneRegion::new));
    private PrimaryNoiseSampler.Settings primarySettings;
    private SecondaryNoiseSampler.Settings secondarySettings;
    private List<StoneType> tertiaries;
    private float tertiaryCutoff;
    private float unconformityCutoff;

    public StoneRegion(PrimaryNoiseSampler.Settings primarySettings, SecondaryNoiseSampler.Settings secondarySettings, List<StoneType> tertiaries, float tertiaryCutoff, float unconformity) {
        this.tertiaryCutoff = tertiaryCutoff;
        this.unconformityCutoff = unconformity;
        this.primarySettings = primarySettings;
        this.secondarySettings = secondarySettings;
        this.tertiaries = tertiaries;
    }

    public PrimaryNoiseSampler.Settings primary() {
        return this.primarySettings;
    }

    public SecondaryNoiseSampler.Settings secondary() {
        return this.secondarySettings;
    }

    public List<StoneType> tertiary() {
        return this.tertiaries;
    }

    public float getTertiaryCutoff() {
        return this.tertiaryCutoff;
    }

    public float getUnconformityCutoff() {
        return this.unconformityCutoff;
    }
}

