/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.world.feature;

import lilypuree.hyle.Constants;
import lilypuree.hyle.world.feature.StoneReplacerConfiguration;
import lilypuree.hyle.world.feature.gen.ChunkFiller;
import lilypuree.hyle.world.feature.gen.NoiseHolder;
import lilypuree.hyle.world.feature.gen.PrimaryNoiseSampler;
import lilypuree.hyle.world.feature.gen.RoughNoiseSampler;
import lilypuree.hyle.world.feature.gen.SecondaryNoiseSampler;
import lilypuree.hyle.world.feature.gen.StoneType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StoneReplacer
extends Feature<StoneReplacerConfiguration> {
    private boolean isSeedSet = false;
    BlockPos basePos;

    public StoneReplacer() {
        super(StoneReplacerConfiguration.CODEC);
    }

    private boolean canReplace(ChunkGenerator generator) {
        if (generator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator nbcg = (NoiseBasedChunkGenerator)generator;
            return ((NoiseGeneratorSettings)nbcg.m_224341_().get()).f_64440_().m_60713_(Blocks.f_50069_);
        }
        return false;
    }

    public boolean m_142674_(FeaturePlaceContext<StoneReplacerConfiguration> ctx) {
        BlockPos pos;
        if (!this.canReplace(ctx.m_159775_())) {
            return false;
        }
        WorldGenLevel level = ctx.m_159774_();
        StoneReplacerConfiguration config = (StoneReplacerConfiguration)ctx.m_159778_();
        if (!this.isSeedSet) {
            int seed = (int)level.m_7328_();
            StoneReplacerConfiguration.Frequencies frequencies = config.getFrequencies();
            NoiseHolder.setSeed(seed - 193864, frequencies.region());
            PrimaryNoiseSampler.setSeed(seed + 777261, frequencies.primary());
            SecondaryNoiseSampler.setSeed(seed + 390271, frequencies.secondary());
            RoughNoiseSampler.setSeed(seed + 1567241, frequencies.tertiary(), frequencies.unconformity());
            this.isSeedSet = true;
        }
        this.basePos = pos = ctx.m_159777_();
        int minY = Math.max(pos.m_123342_(), level.m_141937_());
        ChunkAccess chunkAccess = level.m_46865_(pos);
        NoiseHolder noiseHolder = new NoiseHolder(config, level, pos.m_123341_(), minY, pos.m_123343_());
        int maxHeight = noiseHolder.getMaxHeight(chunkAccess);
        if (maxHeight <= minY) {
            return false;
        }
        ChunkFiller filler = new ChunkFiller(level.m_7328_(), new BlockPos(pos.m_123341_(), minY, pos.m_123343_()), maxHeight - minY + 1);
        if (Constants.CONFIG.enableDebug()) {
            filler.fillIn(2, noiseHolder::getRoughNoise);
            filler.fillEmpty(2, noiseHolder::getStrataNoise);
            filler.fillInEdgesAndFaces(1);
            filler.fillInCentersRandom(1);
        } else {
            filler.fillIn(16, noiseHolder::getRoughNoise);
            filler.fillInEdgesAndFaces(8);
            filler.fillInCenters(8, noiseHolder::getRoughNoise);
            filler.fillEmpty(8, noiseHolder::getStrataNoise);
            filler.fillInEdgesAndFaces(4);
            filler.fillInCenters(4, noiseHolder::getCombinedNoise);
            filler.fillBiome(4, noiseHolder::getBiomeStrata);
            filler.fillInEdgesAndFaces(2);
            filler.fillInCentersFast(2);
            filler.fillInEdgesAndFaces(1);
            filler.fillInCentersRandom(1);
        }
        this.replaceAll(chunkAccess, minY, noiseHolder.getHeights(), filler.results());
        return true;
    }

    private void replaceAll(ChunkAccess chunkAccess, int minY, int[][] heights, StoneType[][][] results) {
        LevelChunkSection chunkSection = chunkAccess.m_183278_(chunkAccess.m_151564_(minY));
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = heights[x][z];
                for (int posY = minY; posY <= height; ++posY) {
                    BlockState replaced;
                    BlockState block;
                    int sectionIndex = chunkAccess.m_151564_(posY);
                    if (chunkAccess.m_151564_(minY) != sectionIndex) {
                        chunkSection = chunkAccess.m_183278_(sectionIndex);
                    }
                    if (chunkSection.m_188008_() || (block = chunkSection.m_62982_(x, posY & 0xF, z)).m_60795_() || block == (replaced = results[x][z][posY - minY].replace(block))) continue;
                    chunkSection.m_62991_(x, posY & 0xF, z, replaced, false);
                }
            }
        }
    }
}

