/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lilypuree.hyle.Constants;
import lilypuree.hyle.misc.HyleDataLoaders;
import lilypuree.hyle.world.feature.BiomeBasedReplacer;
import lilypuree.hyle.world.feature.DebugRegion;
import lilypuree.hyle.world.feature.StoneRegion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraftforge.registries.ForgeRegistries;

public class StoneReplacerConfiguration
implements FeatureConfiguration {
    public static final Codec<StoneReplacerConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeBasedReplacer.CODEC.listOf().fieldOf("biome_replacers").forGetter(x -> x.biomeBasedReplacers), (App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256952_).forGetter(x -> x.biomeRegistry), (App)ResourceLocation.f_135803_.listOf().fieldOf("regions").forGetter(x -> x.regions), (App)Frequencies.CODEC.fieldOf("frequencies").forGetter(x -> x.frequencies)).apply((Applicative)instance, StoneReplacerConfiguration::new));
    private final List<BiomeBasedReplacer> biomeBasedReplacers;
    private final HolderLookup.RegistryLookup<Biome> biomeRegistry;
    private final List<ResourceLocation> regions;
    private final Frequencies frequencies;
    private Set<ResourceLocation> missingRegions = new HashSet<ResourceLocation>();

    public StoneReplacerConfiguration(List<BiomeBasedReplacer> biomeBasedReplacers, HolderLookup.RegistryLookup<Biome> biomes, List<ResourceLocation> regions, Frequencies frequencies) {
        this.biomeBasedReplacers = biomeBasedReplacers;
        this.biomeRegistry = biomes;
        this.regions = regions;
        this.frequencies = frequencies;
    }

    public BiomeBasedReplacer getForBiome(Biome biome) {
        return Optional.ofNullable(ForgeRegistries.BIOMES.getKey((Object)biome)).map(key -> {
            for (BiomeBasedReplacer replacer : this.biomeBasedReplacers) {
                if (!replacer.apply((ResourceKey<Biome>)ForgeRegistries.BIOMES.getResourceKey((Object)biome).orElse(Biomes.f_48174_))) continue;
                return replacer;
            }
            return BiomeBasedReplacer.NONE;
        }).orElse(BiomeBasedReplacer.NONE);
    }

    public Frequencies getFrequencies() {
        return this.frequencies;
    }

    public StoneRegion getRegions(float regionNoise) {
        if (Constants.CONFIG.enableDebug()) {
            return DebugRegion.DEBUG_REGION;
        }
        if (this.regions.isEmpty()) {
            return DebugRegion.EMPTY_REGION;
        }
        ResourceLocation regionID = this.regions.get((int)Mth.m_184631_((float)regionNoise, (float)-1.0f, (float)1.0f, (float)0.0f, (float)this.regions.size()));
        Optional<StoneRegion> region = HyleDataLoaders.getRegion(regionID);
        if (region.isPresent()) {
            return region.get();
        }
        if (!this.missingRegions.contains(regionID)) {
            Constants.LOG.error("Region " + String.valueOf(regionID) + " doesn't exist!");
            this.missingRegions.add(regionID);
        }
        return DebugRegion.EMPTY_REGION;
    }

    public record Frequencies(float region, float unconformity, float primary, float secondary, float tertiary) {
        public static Codec<Frequencies> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("region").forGetter(Frequencies::region), (App)Codec.FLOAT.fieldOf("unconformity").forGetter(Frequencies::unconformity), (App)Codec.FLOAT.fieldOf("primary").forGetter(Frequencies::primary), (App)Codec.FLOAT.fieldOf("secondary").forGetter(Frequencies::secondary), (App)Codec.FLOAT.fieldOf("tertiary").forGetter(Frequencies::tertiary)).apply((Applicative)instance, Frequencies::new));
    }
}

