/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.world.feature.gen;

import com.google.common.base.Functions;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lilypuree.hyle.world.feature.gen.StoneType;
import net.minecraft.core.BlockPos;
import net.openhft.hashing.LongHashFunction;

public class ChunkFiller {
    protected final long seed;
    protected final BlockPos pos;
    protected final StoneType[][][] stoneTypeArray;
    protected final int ySize;

    public ChunkFiller(long seed, BlockPos minPos, int ySize) {
        this.seed = seed;
        this.pos = minPos;
        this.ySize = (int)Math.ceil((double)ySize / 16.0) * 16 + 1;
        this.stoneTypeArray = new StoneType[17][17][this.ySize];
    }

    public StoneType[][][] results() {
        return this.stoneTypeArray;
    }

    public void fillIn(int s, StonetypeGetter stonetypeGetter) {
        for (int x = 0; x < 17; x += s) {
            int posX = x + this.pos.m_123341_();
            for (int z = 0; z < 17; z += s) {
                int posZ = z + this.pos.m_123343_();
                for (int y = 0; y < this.ySize; y += s) {
                    int posY = y + this.pos.m_123342_();
                    this.stoneTypeArray[x][z][y] = stonetypeGetter.get(posX, posY, posZ);
                }
            }
        }
    }

    public void fillEmpty(int s, StonetypeGetter stonetypeGetter) {
        for (int x = 0; x < 17; x += s) {
            int posX = x + this.pos.m_123341_();
            for (int z = 0; z < 17; z += s) {
                int posZ = z + this.pos.m_123343_();
                for (int y = 0; y < this.ySize; y += s) {
                    int posY = y + this.pos.m_123342_();
                    if (this.stoneTypeArray[x][z][y] != StoneType.EMPTY) continue;
                    this.stoneTypeArray[x][z][y] = stonetypeGetter.get(posX, posY, posZ);
                }
            }
        }
    }

    public void fillBiome(int s, StonetypeGetter stonetypeGetter) {
        for (int x = 0; x < 17; x += s) {
            int posX = x + this.pos.m_123341_();
            for (int z = 0; z < 17; z += s) {
                int posZ = z + this.pos.m_123343_();
                for (int y = 0; y < this.ySize; y += s) {
                    StoneType stoneType;
                    int posY = y + this.pos.m_123342_();
                    if (this.stoneTypeArray[x][z][y].ignoresBiome() || (stoneType = stonetypeGetter.get(posX, posY, posZ)) == null) continue;
                    this.stoneTypeArray[x][z][y] = stoneType;
                }
            }
        }
    }

    public void fillInEdgesAndFaces(int s) {
        Iterator i = new Iterator(s);
        do {
            if (i.xMid && !i.yMid) {
                if (i.zMid) {
                    i.set(i.faceY());
                    continue;
                }
                i.set(i.edgeX());
                continue;
            }
            if (i.yMid && !i.zMid) {
                if (i.xMid) {
                    i.set(i.faceZ());
                    continue;
                }
                i.set(i.edgeY());
                continue;
            }
            if (!i.zMid || i.xMid) continue;
            if (i.yMid) {
                i.set(i.faceX());
                continue;
            }
            i.set(i.edgeZ());
        } while (i.next());
    }

    public void fillInCentersRandom(int s) {
        Iterator i = new Iterator(s);
        do {
            if (!i.xMid || !i.yMid || !i.zMid) continue;
            i.set(i.randomCenter());
        } while (i.next());
    }

    public void fillInCentersFast(int s) {
        Iterator i = new Iterator(s);
        do {
            if (!i.xMid || !i.yMid || !i.zMid) continue;
            i.set(i.fastCenter());
        } while (i.next());
    }

    public void fillInCenters(int s, StonetypeGetter stonetypeGetter) {
        Iterator i = new Iterator(s);
        do {
            if (!i.xMid || !i.yMid || !i.zMid) continue;
            i.set(i.center(stonetypeGetter));
        } while (i.next());
    }

    private StoneType select(StoneType state1, StoneType state2, int x, int y, int z) {
        if (state1 == state2) {
            return state1;
        }
        return this.randomIntFast(1, x, y, z) == 0 ? state1 : state2;
    }

    private StoneType select(StoneType state1, StoneType state2, StoneType state3, StoneType state4, int x, int y, int z) {
        if (state1 == state2 && state2 == state3 & state3 == state4) {
            return state1;
        }
        int i = this.randomIntFast(3, x, y, z);
        if (i == 0) {
            return state1;
        }
        if (i == 1) {
            return state2;
        }
        return i == 2 ? state3 : state4;
    }

    private int randomIntFast(int max, int x, int y, int z) {
        return (int)this.getHash(x, y, z) & max;
    }

    private int randomInt(int bound, int x, int y, int z) {
        return Math.floorMod((int)this.getHash(x, y, z), bound);
    }

    private long getHash(int x, int y, int z) {
        return LongHashFunction.xx((long)this.seed).hashInts(new int[]{x, y, z});
    }

    private StoneType selectRandom(StoneType up, StoneType down, StoneType x1, StoneType x2, StoneType z1, StoneType z2, int x, int y, int z) {
        boolean horizontalEquals = x1 == x2 & z1 == z2 & x1 == z1;
        if (horizontalEquals && up == x1 || horizontalEquals && down == x1) {
            return x1;
        }
        int i = this.randomInt(6, x, y, z);
        return switch (i) {
            case 0 -> up;
            case 1 -> down;
            case 2 -> x1;
            case 3 -> x2;
            case 4 -> z1;
            default -> z2;
        };
    }

    private StoneType determineState(StoneType up, StoneType down, StoneType x1, StoneType x2, StoneType z1, StoneType z2, Supplier<StoneType> stateGetter) {
        Optional<StoneType> state = Stream.of(up, down, x1, x2, z1, z2).collect(Collectors.groupingBy(Functions.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
        return state.orElseGet(stateGetter);
    }

    private StoneType determineState(StoneType up, StoneType down, StoneType x1, StoneType x2, StoneType z1, StoneType z2, int x, int y, int z) {
        boolean zSame;
        boolean ySame = up == down;
        boolean xSame = x1 == x2;
        boolean bl = zSame = z1 == z2;
        if (xSame && ySame && zSame) {
            int i = this.randomInt(3, x, y, z);
            if (i == 0) {
                return up;
            }
            return i == 1 ? x1 : z1;
        }
        if (!xSame && zSame && ySame) {
            return this.select(up, z1, x, y, z);
        }
        if (xSame && !zSame && ySame) {
            return this.select(up, x1, x, y, z);
        }
        if (xSame && zSame && !ySame) {
            return this.select(x1, z1, x, y, z);
        }
        if (ySame) {
            return up;
        }
        return this.select(x1, x2, z1, z2, x, y, z);
    }

    @FunctionalInterface
    public static interface StonetypeGetter {
        public StoneType get(int var1, int var2, int var3);
    }

    protected class Iterator {
        protected boolean xMid = false;
        protected boolean yMid = false;
        protected boolean zMid = false;
        protected int posX;
        protected int posZ;
        protected int x;
        protected int y;
        protected int z;
        protected int s;

        public Iterator(int s) {
            this.posX = ChunkFiller.this.pos.m_123341_();
            this.posZ = ChunkFiller.this.pos.m_123343_();
            this.x = 0;
            this.y = 0;
            this.z = 0;
            this.s = s;
        }

        public boolean next() {
            this.y += this.s;
            if (this.y >= ChunkFiller.this.ySize) {
                this.yMid = false;
                this.y = 0;
                this.z += this.s;
                if (this.z >= 17) {
                    this.zMid = false;
                    this.z = 0;
                    this.x += this.s;
                    if (this.x >= 17) {
                        return false;
                    }
                    this.xMid = !this.xMid;
                    this.posX = ChunkFiller.this.pos.m_123341_() + this.x;
                    return true;
                }
                this.posZ = ChunkFiller.this.pos.m_123343_() + this.z;
                this.zMid = !this.zMid;
                return true;
            }
            this.yMid = !this.yMid;
            return true;
        }

        private StoneType edgeX() {
            return ChunkFiller.this.select(ChunkFiller.this.stoneTypeArray[this.x - this.s][this.z][this.y], ChunkFiller.this.stoneTypeArray[this.x + this.s][this.z][this.y], this.posX, this.y, this.posZ);
        }

        private StoneType edgeZ() {
            return ChunkFiller.this.select(ChunkFiller.this.stoneTypeArray[this.x][this.z - this.s][this.y], ChunkFiller.this.stoneTypeArray[this.x][this.z + this.s][this.y], this.posX, this.y, this.posZ);
        }

        private StoneType edgeY() {
            return ChunkFiller.this.select(ChunkFiller.this.stoneTypeArray[this.x][this.z][this.y - this.s], ChunkFiller.this.stoneTypeArray[this.x][this.z][this.y + this.s], this.posX, this.y, this.posZ);
        }

        private StoneType faceX() {
            return ChunkFiller.this.select(ChunkFiller.this.stoneTypeArray[this.x][this.z - this.s][this.y - this.s], ChunkFiller.this.stoneTypeArray[this.x][this.z + this.s][this.y - this.s], ChunkFiller.this.stoneTypeArray[this.x][this.z - this.s][this.y + this.s], ChunkFiller.this.stoneTypeArray[this.x][this.z + this.s][this.y + this.s], this.posX, this.y, this.posZ);
        }

        private StoneType faceZ() {
            return ChunkFiller.this.select(ChunkFiller.this.stoneTypeArray[this.x - this.s][this.z][this.y - this.s], ChunkFiller.this.stoneTypeArray[this.x + this.s][this.z][this.y - this.s], ChunkFiller.this.stoneTypeArray[this.x - this.s][this.z][this.y + this.s], ChunkFiller.this.stoneTypeArray[this.x + this.s][this.z][this.y + this.s], this.posX, this.y, this.posZ);
        }

        private StoneType faceY() {
            return ChunkFiller.this.select(ChunkFiller.this.stoneTypeArray[this.x - this.s][this.z - this.s][this.y], ChunkFiller.this.stoneTypeArray[this.x + this.s][this.z - this.s][this.y], ChunkFiller.this.stoneTypeArray[this.x - this.s][this.z + this.s][this.y], ChunkFiller.this.stoneTypeArray[this.x + this.s][this.z + this.s][this.y], this.posX, this.y, this.posZ);
        }

        private StoneType randomCenter() {
            return ChunkFiller.this.selectRandom(ChunkFiller.this.stoneTypeArray[this.x][this.z][this.y + this.s], ChunkFiller.this.stoneTypeArray[this.x][this.z][this.y - this.s], ChunkFiller.this.stoneTypeArray[this.x - this.s][this.z][this.y], ChunkFiller.this.stoneTypeArray[this.x + this.s][this.z][this.y], ChunkFiller.this.stoneTypeArray[this.x][this.z - this.s][this.y], ChunkFiller.this.stoneTypeArray[this.x][this.z + this.s][this.y], this.posX, this.y, this.posZ);
        }

        private StoneType center(StonetypeGetter getter) {
            return ChunkFiller.this.determineState(ChunkFiller.this.stoneTypeArray[this.x][this.z][this.y + this.s], ChunkFiller.this.stoneTypeArray[this.x][this.z][this.y - this.s], ChunkFiller.this.stoneTypeArray[this.x - this.s][this.z][this.y], ChunkFiller.this.stoneTypeArray[this.x + this.s][this.z][this.y], ChunkFiller.this.stoneTypeArray[this.x][this.z - this.s][this.y], ChunkFiller.this.stoneTypeArray[this.x][this.z + this.s][this.y], () -> getter.get(this.posX, ChunkFiller.this.pos.m_123342_() + this.y, this.posZ));
        }

        private StoneType fastCenter() {
            return ChunkFiller.this.determineState(ChunkFiller.this.stoneTypeArray[this.x][this.z][this.y + this.s], ChunkFiller.this.stoneTypeArray[this.x][this.z][this.y - this.s], ChunkFiller.this.stoneTypeArray[this.x - this.s][this.z][this.y], ChunkFiller.this.stoneTypeArray[this.x + this.s][this.z][this.y], ChunkFiller.this.stoneTypeArray[this.x][this.z - this.s][this.y], ChunkFiller.this.stoneTypeArray[this.x][this.z + this.s][this.y], this.posX, this.y, this.posZ);
        }

        private void set(StoneType state) {
            ChunkFiller.this.stoneTypeArray[this.x][this.z][this.y] = state;
        }
    }
}

