/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.world.feature.gen;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import lilypuree.hyle.util.noise.FastNoiseLite;
import lilypuree.hyle.world.feature.BiomeBasedReplacer;
import lilypuree.hyle.world.feature.StoneRegion;
import lilypuree.hyle.world.feature.StoneReplacerConfiguration;
import lilypuree.hyle.world.feature.gen.ChunkFiller;
import lilypuree.hyle.world.feature.gen.PrimaryNoiseSampler;
import lilypuree.hyle.world.feature.gen.RoughNoiseSampler;
import lilypuree.hyle.world.feature.gen.StoneType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;

public class NoiseHolder {
    private static FastNoiseLite regionNoise;
    private Map<Integer, Map<Integer, ChunkFiller.StonetypeGetter>> roughNoiseSamplers = new Int2ObjectOpenHashMap(3);
    private Map<Integer, Map<Integer, ChunkFiller.StonetypeGetter>> strataNoiseSamplers = new Int2ObjectArrayMap(5);
    private StoneReplacerConfiguration configuration;
    private WorldGenLevel level;
    private int baseX;
    private int baseY;
    private int baseZ;
    private int[][] heights = new int[17][17];
    private int[][] strata_depth = new int[5][5];
    private BiomeBasedReplacer[][] replacers = new BiomeBasedReplacer[5][5];
    private StoneRegion[][] regions = new StoneRegion[5][5];

    public NoiseHolder(StoneReplacerConfiguration cfg, WorldGenLevel worldGenLevel, int posX, int minY, int posZ) {
        this.configuration = cfg;
        this.level = worldGenLevel;
        this.baseX = posX;
        this.baseY = minY;
        this.baseZ = posZ;
    }

    public int[][] getHeights() {
        return this.heights;
    }

    public int getMaxHeight(ChunkAccess chunkAccess) {
        int maxHeight = Integer.MIN_VALUE;
        for (int x = 0; x < 17; ++x) {
            for (int z = 0; z < 17; ++z) {
                int height = x < 16 && z < 16 ? chunkAccess.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z) : this.level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x + this.baseX, z + this.baseZ);
                maxHeight = Math.max(height, maxHeight);
                this.heights[x][z] = height;
            }
        }
        return maxHeight;
    }

    public StoneType getRoughNoise(int posX, int posY, int posZ) {
        return this.roughNoiseSamplers.computeIfAbsent(posX, i -> new Int2ObjectOpenHashMap(3)).computeIfAbsent(posZ, i -> this.getRoughNoiseSampler(posX, posZ)).get(posX, posY, posZ);
    }

    public StoneType getStrataNoise(int posX, int posY, int posZ) {
        return this.strataNoiseSamplers.computeIfAbsent(posX, i -> new Int2ObjectOpenHashMap(5)).computeIfAbsent(posZ, i -> this.getPrimaryNoiseSampler(posX, posZ)).get(posX, posY, posZ);
    }

    public StoneType getCombinedNoise(int posX, int posY, int posZ) {
        StoneType state = this.getRoughNoise(posX, posY, posZ);
        return state == StoneType.EMPTY ? this.getStrataNoise(posX, posY, posZ) : state;
    }

    public StoneType getBiomeStrata(int posX, int posY, int posZ) {
        int x1 = posX - this.baseX >> 2;
        int z1 = posZ - this.baseZ >> 2;
        BiomeBasedReplacer replacer = this.replacers[x1][z1];
        int height = this.heights[posX - this.baseX][posZ - this.baseZ];
        int depth = height - posY;
        if (replacer == null) {
            Holder biome = this.level.m_204166_(new BlockPos(posX, this.baseY + height, posZ));
            replacer = this.configuration.getForBiome((Biome)biome.m_203334_());
            this.strata_depth[x1][z1] = replacer.getTotalThickness();
            this.replacers[x1][z1] = replacer;
        }
        if (depth < this.strata_depth[x1][z1]) {
            return replacer.compute(depth);
        }
        return null;
    }

    public StoneRegion getRegion(int posX, int posZ) {
        int x1 = posX - this.baseX >> 2;
        int z1 = posZ - this.baseZ >> 2;
        StoneRegion region = this.regions[x1][z1];
        if (region == null) {
            this.regions[x1][z1] = region = this.configuration.getRegions(regionNoise.GetNoise(posX, posZ));
        }
        return region;
    }

    private ChunkFiller.StonetypeGetter getRoughNoiseSampler(int posX, int posZ) {
        int height = this.heights[posX - this.baseX][posZ - this.baseZ];
        return new RoughNoiseSampler(this.getRegion(posX, posZ), posX, posZ, this.baseY, height);
    }

    private ChunkFiller.StonetypeGetter getPrimaryNoiseSampler(int posX, int posZ) {
        return new PrimaryNoiseSampler(this.getRegion(posX, posZ).primary(), posX, posZ, this.baseY);
    }

    public static void setSeed(int seed, float regionFrequency) {
        regionNoise = new FastNoiseLite(seed);
        regionNoise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
        regionNoise.SetCellularReturnType(FastNoiseLite.CellularReturnType.CellValue);
        regionNoise.SetFrequency(regionFrequency);
    }
}

