/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.world.feature.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import lilypuree.hyle.util.noise.FastNoiseLite;
import lilypuree.hyle.world.feature.gen.ChunkFiller;
import lilypuree.hyle.world.feature.gen.StoneType;
import net.minecraft.util.Mth;

public class PrimaryNoiseSampler
implements ChunkFiller.StonetypeGetter {
    private static FastNoiseLite primaryNoiseA;
    private static FastNoiseLite primaryNoiseB;
    private float primary;
    private Settings settings;
    private int minY;

    public PrimaryNoiseSampler(Settings settings, int posX, int posZ, int minY) {
        this.settings = settings;
        this.primary = this.getPrimaryNoise(posX, posZ);
        this.minY = minY;
    }

    @Override
    public StoneType get(int posX, int posY, int posZ) {
        int y = posY - this.minY;
        float modifiedPrimary = this.primary + Mth.m_184637_((float)y, (float)120.0f, (float)0.0f, (float)0.0f, (float)this.settings.strataFlatness);
        if (modifiedPrimary > this.settings.deepBound) {
            return this.settings.deep;
        }
        if (modifiedPrimary >= this.settings.strataBound) {
            return this.settings.base;
        }
        if (modifiedPrimary < this.settings.highBound) {
            return this.settings.high;
        }
        if (this.settings.strataSize() > 0) {
            int strataIndex = (int)Mth.m_184631_((float)modifiedPrimary, (float)this.settings.highBound, (float)this.settings.strataBound, (float)0.0f, (float)this.settings.strataSize());
            return this.settings.stratas.get(strataIndex);
        }
        return this.settings.base;
    }

    public float getPrimaryNoise(int posX, int posZ) {
        float threshold = -0.5f;
        float noiseA = Math.max(primaryNoiseA.GetNoise(posX, posZ), threshold);
        float noiseB = Math.max(primaryNoiseB.GetNoise(posX, posZ), threshold);
        return Mth.m_184637_((float)(noiseA + noiseB), (float)(threshold * 2.0f), (float)2.0f, (float)-1.0f, (float)1.0f);
    }

    public static void setSeed(int seed, float primaryFrequency) {
        primaryNoiseA = new FastNoiseLite(seed);
        primaryNoiseA.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        primaryNoiseA.SetFractalType(FastNoiseLite.FractalType.FBm);
        primaryNoiseA.SetFractalOctaves(3);
        primaryNoiseA.SetFrequency(primaryFrequency);
        primaryNoiseB = new FastNoiseLite(seed + 2347);
        primaryNoiseB.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        primaryNoiseB.SetFractalType(FastNoiseLite.FractalType.FBm);
        primaryNoiseB.SetFractalOctaves(3);
        primaryNoiseB.SetFrequency(primaryFrequency * 1.01f);
    }

    public record Settings(StoneType high, List<StoneType> stratas, StoneType base, StoneType deep, float highBound, float strataBound, float deepBound, float strataFlatness) {
        public static Codec<Settings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StoneType.CODEC.fieldOf("high").forGetter(Settings::high), (App)StoneType.CODEC.listOf().fieldOf("stratas").forGetter(Settings::stratas), (App)StoneType.CODEC.fieldOf("base").forGetter(Settings::base), (App)StoneType.CODEC.fieldOf("deep").forGetter(Settings::deep), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("high_bound").forGetter(Settings::highBound), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("strata_bound").forGetter(Settings::strataBound), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("deep_bound").forGetter(Settings::deepBound), (App)Codec.floatRange((float)0.0f, (float)10.0f).fieldOf("strata_flatness").forGetter(Settings::strataFlatness)).apply((Applicative)instance, Settings::new));

        public int strataSize() {
            return this.stratas.size();
        }
    }
}

