/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.world.feature.gen;

import lilypuree.hyle.util.noise.FastNoiseLite;
import lilypuree.hyle.world.feature.StoneRegion;
import lilypuree.hyle.world.feature.gen.ChunkFiller;
import lilypuree.hyle.world.feature.gen.SecondaryNoiseSampler;
import lilypuree.hyle.world.feature.gen.StoneType;
import net.minecraft.util.Mth;

public class RoughNoiseSampler
implements ChunkFiller.StonetypeGetter {
    private static FastNoiseLite tertiaryNoise;
    private static FastNoiseLite unconformityNoise;
    private SecondaryNoiseSampler secondaryNoiseSampler;
    private StoneRegion region;

    public RoughNoiseSampler(StoneRegion region, int posX, int posZ, int minY, int height) {
        float unconformity = unconformityNoise.GetNoise(posX, posZ);
        float cutoff = region.getUnconformityCutoff();
        int unconformityBoundary = minY + (int)Mth.m_184637_((float)unconformity, (float)(-0.2f + cutoff), (float)(0.2f + cutoff), (float)0.0f, (float)160.0f);
        this.secondaryNoiseSampler = new SecondaryNoiseSampler(region.secondary(), unconformityBoundary, height);
        this.region = region;
    }

    @Override
    public StoneType get(int posX, int posY, int posZ) {
        StoneType tertiary = this.selectTertiary(tertiaryNoise.GetNoise(posX, posY, posZ));
        if (tertiary != null) {
            return tertiary;
        }
        return this.secondaryNoiseSampler.get(posX, posY, posZ);
    }

    protected StoneType selectTertiary(float tertiaryNoise) {
        float cubed = tertiaryNoise * tertiaryNoise * tertiaryNoise;
        float cutOffOriginal = (float)Math.pow(this.region.getTertiaryCutoff(), 0.3333333333333333);
        if (cubed > this.region.getTertiaryCutoff()) {
            return this.region.tertiary().get((int)Mth.m_184631_((float)tertiaryNoise, (float)cutOffOriginal, (float)1.0f, (float)0.0f, (float)this.region.tertiary().size()));
        }
        return null;
    }

    public static void setSeed(int seed, float tertiaryFreq, float unconformityFreq) {
        tertiaryNoise = new FastNoiseLite(seed);
        tertiaryNoise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
        tertiaryNoise.SetFractalType(FastNoiseLite.FractalType.None);
        tertiaryNoise.SetCellularReturnType(FastNoiseLite.CellularReturnType.CellValue);
        tertiaryNoise.SetFrequency(tertiaryFreq);
        unconformityNoise = new FastNoiseLite(seed - 55791);
        unconformityNoise.SetFractalType(FastNoiseLite.FractalType.FBm);
        unconformityNoise.SetFractalOctaves(2);
        unconformityNoise.SetFrequency(unconformityFreq);
    }
}

