/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.world.feature.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import lilypuree.hyle.util.noise.FastNoiseLite;
import lilypuree.hyle.world.feature.gen.ChunkFiller;
import lilypuree.hyle.world.feature.gen.StoneType;
import net.minecraft.util.Mth;

public class SecondaryNoiseSampler
implements ChunkFiller.StonetypeGetter {
    private static FastNoiseLite typeNoise;
    private static FastNoiseLite warpNoise;
    private Settings settings;
    private int unconformityBoundary;
    private int primaryBoundary;
    private int deepBoundary;

    public SecondaryNoiseSampler(Settings settings, int unconformityBoundary, int height) {
        this.settings = settings;
        this.unconformityBoundary = unconformityBoundary;
        this.primaryBoundary = height - settings.firstLayerThickness;
        this.deepBoundary = height - settings.deepLayerDepth;
    }

    @Override
    public StoneType get(int posX, int posY, int posZ) {
        if (this.unconformityBoundary < posY) {
            if (posY > this.primaryBoundary) {
                FastNoiseLite.Vector3 v3 = new FastNoiseLite.Vector3(posX, (float)posY / 4.0f, posZ);
                warpNoise.DomainWarp(v3);
                return this.select(typeNoise.GetNoise(v3.x, v3.y, v3.z));
            }
            if (posY > this.deepBoundary) {
                return this.settings.base;
            }
            return this.settings.deep;
        }
        return StoneType.EMPTY;
    }

    protected StoneType select(float primaryNoise) {
        return this.settings.stoneTypes().get((int)Mth.m_184631_((float)primaryNoise, (float)-1.0f, (float)1.0f, (float)0.0f, (float)this.settings.count()));
    }

    public static void setSeed(int seed, float secondaryFreq) {
        typeNoise = new FastNoiseLite(seed);
        typeNoise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
        typeNoise.SetFractalType(FastNoiseLite.FractalType.None);
        typeNoise.SetCellularReturnType(FastNoiseLite.CellularReturnType.CellValue);
        typeNoise.SetCellularJitter(0.9f);
        typeNoise.SetFrequency(secondaryFreq);
        warpNoise = new FastNoiseLite(seed + 2881);
        warpNoise.SetFractalType(FastNoiseLite.FractalType.DomainWarpIndependent);
        warpNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        warpNoise.SetDomainWarpAmp(30.0f);
        warpNoise.SetFractalOctaves(3);
        warpNoise.SetFrequency(secondaryFreq * 0.9f);
    }

    public record Settings(List<StoneType> stoneTypes, StoneType base, StoneType deep, int firstLayerThickness, int deepLayerDepth) {
        public static Codec<Settings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StoneType.CODEC.listOf().fieldOf("top_layer_types").forGetter(Settings::stoneTypes), (App)StoneType.CODEC.fieldOf("base").forGetter(Settings::base), (App)StoneType.CODEC.fieldOf("deep").forGetter(Settings::deep), (App)Codec.intRange((int)0, (int)4096).fieldOf("top_layer_thickness").forGetter(Settings::firstLayerThickness), (App)Codec.intRange((int)0, (int)4096).fieldOf("deep_layer_depth").forGetter(Settings::deepLayerDepth)).apply((Applicative)instance, Settings::new));

        public int count() {
            return this.stoneTypes.size();
        }
    }
}

