/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.hyle.world.feature.gen;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lilypuree.hyle.Constants;
import lilypuree.hyle.compat.IStoneType;
import lilypuree.hyle.core.HyleTags;
import lilypuree.hyle.misc.HyleDataLoaders;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StoneType
implements IStoneType {
    public static final StoneType EMPTY = new StoneType(null);
    public static final StoneType NO_REPLACE = new StoneType(null){

        @Override
        public BlockState replace(BlockState original) {
            return original;
        }
    };
    private static final Codec<BlockState> BLOCK_OR_BLOCKSTATE_CODEC = Codec.either((Codec)ResourceLocation.f_135803_.comapFlatMap(loc -> Optional.ofNullable((Block)ForgeRegistries.BLOCKS.getValue(loc)).map(DataResult::success).orElse(DataResult.error(() -> String.format("block %s doesn't exist!", loc))), arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0)), (Codec)BlockState.f_61039_).xmap(either -> (BlockState)either.map(Block::m_49966_, b -> b), Either::right);
    public static final Codec<StoneType> CODEC = Codec.STRING.comapFlatMap(string -> {
        StoneType stoneType = HyleDataLoaders.getStoneType(string);
        if (stoneType == null) {
            return DataResult.error(() -> "Stone type " + string + " doesn't exist!", (Object)NO_REPLACE);
        }
        return DataResult.success((Object)stoneType);
    }, HyleDataLoaders::getNameForStoneType);
    public static Codec<StoneType> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BLOCK_OR_BLOCKSTATE_CODEC.fieldOf("base").forGetter(state -> state.baseBlock), (App)BLOCK_OR_BLOCKSTATE_CODEC.optionalFieldOf("cobble").forGetter(state -> Optional.ofNullable(state.cobbleBlock)), (App)BLOCK_OR_BLOCKSTATE_CODEC.optionalFieldOf("dirt").forGetter(state -> Optional.ofNullable(state.dirtReplace)), (App)BLOCK_OR_BLOCKSTATE_CODEC.optionalFieldOf("grass").forGetter(state -> Optional.ofNullable(state.grassReplace)), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, BLOCK_OR_BLOCKSTATE_CODEC).optionalFieldOf("ores", Collections.emptyMap()).forGetter(StoneType::getOreMapInner), (App)Codec.BOOL.optionalFieldOf("ignore_biome", (Object)false).forGetter(state -> state.ignoreBiome)).apply((Applicative)instance, StoneType::new));
    private final BlockState baseBlock;
    private BlockState cobbleBlock;
    private BlockState dirtReplace;
    private BlockState grassReplace;
    private Map<Block, BlockState> oreMap;
    private boolean ignoreBiome;

    public StoneType(BlockState baseBlock, Optional<BlockState> cobbleBlock, Optional<BlockState> dirtReplace, Optional<BlockState> grassReplace, Map<ResourceLocation, BlockState> oreMap, boolean ignoreBiome) {
        this.baseBlock = baseBlock;
        this.cobbleBlock = Constants.CONFIG.disableCobbleReplacement() ? null : (BlockState)cobbleBlock.orElse(null);
        this.dirtReplace = Constants.CONFIG.disableDirtReplacement() ? null : (BlockState)dirtReplace.orElse(null);
        this.grassReplace = Constants.CONFIG.disableDirtReplacement() ? null : (BlockState)grassReplace.orElse(null);
        this.oreMap = new HashMap<Block, BlockState>();
        oreMap.forEach((key, blockState) -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
            this.oreMap.put(block, (BlockState)blockState);
        });
        this.ignoreBiome = ignoreBiome;
    }

    public StoneType(BlockState baseBlock) {
        this.baseBlock = baseBlock;
        this.cobbleBlock = baseBlock;
        this.dirtReplace = baseBlock;
        this.grassReplace = baseBlock;
        this.oreMap = Collections.emptyMap();
        this.ignoreBiome = false;
    }

    public boolean ignoresBiome() {
        return this.ignoreBiome;
    }

    private BlockState getGrassReplace(BlockState original) {
        if (this.grassReplace.m_61138_((Property)BlockStateProperties.f_61451_)) {
            return (BlockState)this.grassReplace.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)((Boolean)original.m_61143_((Property)BlockStateProperties.f_61451_)));
        }
        return this.grassReplace;
    }

    private Map<ResourceLocation, BlockState> getOreMapInner() {
        HashMap<ResourceLocation, BlockState> newMap = new HashMap<ResourceLocation, BlockState>();
        this.oreMap.forEach((block, state) -> newMap.put(ForgeRegistries.BLOCKS.getKey(block), (BlockState)state));
        return newMap;
    }

    public void toImmutable() {
        this.oreMap = Constants.CONFIG.disableOreReplacement() ? Collections.emptyMap() : ImmutableMap.builder().putAll(this.oreMap).build();
    }

    @Override
    public BlockState getBaseBlock() {
        return this.baseBlock;
    }

    @Override
    public BlockState getCobbleBlock() {
        return this.cobbleBlock;
    }

    @Override
    public void setCobbleBlock(BlockState cobbleBlock) {
        this.cobbleBlock = cobbleBlock;
    }

    @Override
    public BlockState getDirtReplace() {
        return this.dirtReplace;
    }

    @Override
    public void setDirtReplace(BlockState dirtReplace) {
        this.dirtReplace = dirtReplace;
    }

    @Override
    public BlockState getGrassReplace() {
        return this.grassReplace;
    }

    @Override
    public void setGrassReplace(BlockState grassReplace) {
        this.grassReplace = grassReplace;
    }

    @Override
    public Map<Block, BlockState> getOreMap() {
        return this.oreMap;
    }

    public BlockState replace(BlockState original) {
        if (original.m_204336_(HyleTags.Blocks.REPLACABLE)) {
            return this.baseBlock;
        }
        if (original.m_60713_(Blocks.f_50652_) && this.cobbleBlock != null) {
            return this.cobbleBlock;
        }
        if (original.m_204336_(HyleTags.Blocks.REPLACE_DIRT) && this.dirtReplace != null) {
            return this.dirtReplace;
        }
        if (original.m_204336_(HyleTags.Blocks.REPLACE_GRASS) && this.grassReplace != null) {
            return this.getGrassReplace(original);
        }
        for (Block block : this.oreMap.keySet()) {
            if (!original.m_60713_(block)) continue;
            return this.oreMap.get(block);
        }
        return original;
    }
}

