/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import lilypuree.unearthed.block.properties.ModBlockProperties;
import lilypuree.unearthed.core.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LichenBlock
extends GlowLichenBlock {
    public static BooleanProperty WET = ModBlockProperties.WET;
    public static BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = PipeBlock.f_55154_;
    public static Map<Block, Block> lichenErosionMap = new Object2ObjectOpenHashMap();

    public LichenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WET, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WET});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_43722_().m_150930_((Item)Registration.LICHEN_ITEM.get()) || super.m_6864_(state, useContext);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public static int countBlocksLichenIsAttachedTo(BlockState state) {
        int i = 0;
        for (BooleanProperty booleanproperty : FACING_TO_PROPERTY_MAP.values()) {
            if (!((Boolean)state.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (random.m_188503_(5) == 0) {
            for (Direction dir : Direction.values()) {
                if (!((Boolean)state.m_61143_((Property)LichenBlock.m_153933_((Direction)dir))).booleanValue()) continue;
                this.tryErodeBlock((Level)worldIn, pos.m_121945_(dir));
            }
        }
    }

    private static boolean hasWater(LevelReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-2, -2, -2), (BlockPos)pos.m_7918_(2, 2, 2))) {
            if (!worldIn.m_6425_(blockpos).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEnoughLichen(BlockGetter blockReader, BlockPos pos, int max, int range, int vertRange) {
        Iterable iterable = BlockPos.m_121976_((int)(pos.m_123341_() - range), (int)(pos.m_123342_() - vertRange), (int)(pos.m_123343_() - range), (int)(pos.m_123341_() + range), (int)(pos.m_123342_() + vertRange), (int)(pos.m_123343_() + range));
        int j = max;
        for (BlockPos blockpos : iterable) {
            BlockState state = blockReader.m_8055_(blockpos);
            if (!state.m_60713_((Block)Registration.LICHEN.get()) || (j -= LichenBlock.countBlocksLichenIsAttachedTo(state)) > 0) continue;
            return true;
        }
        return false;
    }

    public static void addErosionMap(Block block, Block eroded) {
        lichenErosionMap.put(block, eroded);
    }

    public void tryErodeBlock(Level world, BlockPos pos) {
        BlockState block = world.m_8055_(pos);
        if (lichenErosionMap.containsKey(block.m_60734_())) {
            Block eroded;
            int coveredSides = 0;
            for (Direction dir : Direction.values()) {
                BlockState newBlock = world.m_8055_(pos.m_121945_(dir));
                if (!newBlock.m_60713_((Block)this) || !((Boolean)newBlock.m_61143_((Property)LichenBlock.m_153933_((Direction)dir.m_122424_()))).booleanValue()) continue;
                ++coveredSides;
            }
            if (coveredSides >= 5 && (eroded = lichenErosionMap.get(block.m_60734_())) != null) {
                world.m_46597_(pos, eroded.m_49966_());
            }
        }
    }
}

