/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import lilypuree.unearthed.block.RegolithBlock;
import lilypuree.unearthed.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import org.jetbrains.annotations.Nullable;

public class RegolithGrassBlock
extends GrassBlock {
    public static Map<Block, Block> regolithToGrassMap = new Object2ObjectOpenHashMap();
    private Block regolithBlock;

    public RegolithGrassBlock(Block regolithBlock, BlockBehaviour.Properties properties) {
        super(properties);
        this.regolithBlock = regolithBlock;
        regolithToGrassMap.put(regolithBlock, (Block)this);
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!RegolithGrassBlock.m_56823_(state, (LevelReader)worldIn, pos)) {
            worldIn.m_46597_(pos, this.regolithBlock.m_49966_());
        } else if (worldIn.m_46803_(pos.m_7494_()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 2, random.m_188503_(3) - 1);
                BlockState blockState = worldIn.m_8055_(blockpos);
                if (blockState.m_60734_() instanceof RegolithBlock && regolithToGrassMap.containsKey(blockState.m_60734_()) && RegolithGrassBlock.m_56827_(blockState, (LevelReader)worldIn, blockpos)) {
                    worldIn.m_46597_(blockpos, regolithToGrassMap.get(blockState.m_60734_()).m_49966_());
                    continue;
                }
                if (!blockState.m_60713_(Blocks.f_50493_) || !RegolithGrassBlock.m_56827_(blockState, (LevelReader)worldIn, blockpos)) continue;
                worldIn.m_46597_(blockpos, Blocks.f_50440_.m_49966_());
            }
        }
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState $$3, @Nullable BlockEntity $$4, ItemStack stack) {
        super.m_6240_(level, player, pos, $$3, $$4, stack);
        if (this.regolithBlock instanceof RegolithBlock && Services.PLATFORM.isDiggingHoe(stack)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        }
    }

    public static boolean m_56823_(BlockState state, LevelReader worldReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = worldReader.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50125_) && (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LightEngine.m_284282_((BlockGetter)worldReader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)worldReader, blockpos));
        return i < worldReader.m_7469_();
    }

    public static boolean m_56827_(BlockState state, LevelReader worldReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return RegolithGrassBlock.m_56823_(state, worldReader, pos) && !worldReader.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    public Block getRegolithBlock() {
        return this.regolithBlock;
    }

    static {
        regolithToGrassMap.put(Blocks.f_50493_, Blocks.f_50440_);
    }
}

