/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.block;

import lilypuree.unearthed.block.properties.ModBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SixwaySlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACE = BlockStateProperties.f_61372_;
    public static final DirectionProperty SECONDARY_FACING = ModBlockProperties.SECONDARY_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape[] directionShapes = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    protected static VoxelShape[][] shapeArray;

    public SixwaySlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACE, (Comparable)Direction.DOWN)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SECONDARY_FACING, (Comparable)Direction.DOWN));
        shapeArray = SixwaySlabBlock.getShapeArray();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACE, WATERLOGGED, SECONDARY_FACING});
    }

    protected static VoxelShape[][] getShapeArray() {
        VoxelShape[][] shapes = new VoxelShape[6][6];
        for (Direction direction : Direction.values()) {
            for (Direction otherDir : Direction.values()) {
                int directionIndex = direction.ordinal();
                int directionIndex2 = otherDir.ordinal();
                shapes[directionIndex][directionIndex2] = Shapes.m_83110_((VoxelShape)directionShapes[directionIndex], (VoxelShape)directionShapes[directionIndex2]);
            }
        }
        return shapes;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shapeArray[((Direction)state.m_61143_((Property)FACE)).ordinal()][((Direction)state.m_61143_((Property)SECONDARY_FACING)).ordinal()];
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        FluidState ifluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState currentState = context.m_43725_().m_8055_(blockpos);
        Direction placeDir = this.getPlaceDir(context);
        if (currentState.m_60713_((Block)this)) {
            boolean waterLoggedFlag = (Boolean)currentState.m_61143_((Property)WATERLOGGED) != false && placeDir != currentState.m_61143_((Property)FACE);
            return (BlockState)((BlockState)((BlockState)currentState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLoggedFlag))).m_61124_((Property)FACE, (Comparable)((Direction)currentState.m_61143_((Property)FACE)))).m_61124_((Property)SECONDARY_FACING, (Comparable)placeDir);
        }
        boolean waterLoggedFlag = ifluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLoggedFlag))).m_61124_((Property)FACE, (Comparable)placeDir)).m_61124_((Property)SECONDARY_FACING, (Comparable)placeDir);
    }

    public boolean hasTwoSides(BlockState state) {
        return state.m_61143_((Property)FACE) != state.m_61143_((Property)SECONDARY_FACING);
    }

    public boolean isFullBlock(BlockState state) {
        return state.m_61143_((Property)FACE) == ((Direction)state.m_61143_((Property)SECONDARY_FACING)).m_122424_();
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        if (!this.hasTwoSides(state) && itemstack.m_41720_() == this.m_5456_()) {
            if (useContext.m_7058_()) {
                return useContext.m_43719_() == ((Direction)state.m_61143_((Property)FACE)).m_122424_();
            }
            Direction placeDir = this.getPlaceDir(useContext);
            return state.m_61143_((Property)SECONDARY_FACING) != placeDir;
        }
        return false;
    }

    protected Direction getPlaceDir(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState currentState = context.m_43725_().m_8055_(blockpos);
        Direction placeDir = context.m_43719_().m_122424_();
        if (currentState.m_60713_((Block)this) && placeDir == currentState.m_61143_((Property)FACE)) {
            placeDir = placeDir.m_122424_();
        }
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            if (placeDir.m_122434_() != Direction.Axis.Y) {
                placeDir = context.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5 ? Direction.UP : Direction.DOWN;
            } else {
                Direction lookDir = context.m_8125_();
                if (lookDir.m_122434_() == Direction.Axis.X) {
                    placeDir = context.m_43720_().f_82479_ - (double)blockpos.m_123341_() > 0.5 ? Direction.EAST : Direction.WEST;
                } else if (lookDir.m_122434_() == Direction.Axis.Z) {
                    placeDir = context.m_43720_().f_82481_ - (double)blockpos.m_123343_() > 0.5 ? Direction.SOUTH : Direction.NORTH;
                }
            }
        }
        return placeDir;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return !this.isFullBlock(state) && super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return !this.isFullBlock(state) && super.m_6044_(worldIn, pos, state, fluidIn);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

