/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.block.schema;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import lilypuree.unearthed.block.schema.BlockForm;
import lilypuree.unearthed.block.schema.BlockVariant;
import lilypuree.unearthed.block.schema.Forms;
import lilypuree.unearthed.block.schema.SchemaEntry;
import lilypuree.unearthed.block.schema.Variants;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BlockSchema {
    private String name;
    private Block defaultBlock = Blocks.f_50069_;
    private Multimap<BlockVariant, SchemaEntry> variantEntries;
    private Map<BlockVariant, SchemaEntry> variantBaseEntries;
    private SchemaEntry baseEntry;

    private BlockSchema(String name, Multimap<BlockVariant, SchemaEntry> entries) {
        this.name = name;
        this.variantEntries = entries;
        this.variantBaseEntries = new HashMap<BlockVariant, SchemaEntry>();
        for (SchemaEntry entry : entries.values()) {
            if (!entry.form.isBaseForm()) continue;
            this.variantBaseEntries.put(entry.variant, entry);
            if (!entry.variant.isBaseVariant()) continue;
            this.baseEntry = entry;
        }
    }

    public void forEach(BiConsumer<BlockVariant, SchemaEntry> biConsumer) {
        this.variantEntries.forEach(biConsumer);
    }

    public Collection<BlockVariant> variants() {
        return this.variantEntries.keys();
    }

    public Collection<SchemaEntry> entries() {
        return this.variantEntries.values();
    }

    public SchemaEntry getEntry(BlockVariant variant, BlockForm form) {
        return this.variantEntries.get((Object)variant).stream().filter(entry -> entry.form == form).findAny().orElse(null);
    }

    public SchemaEntry getBaseEntry() {
        return this.baseEntry;
    }

    public Block getBaseBlock(BlockVariant variant) {
        if (this.variantBaseEntries.containsKey(variant)) {
            return this.variantBaseEntries.get((Object)variant).block;
        }
        return this.defaultBlock;
    }

    public void setDefaultBlock(Block defaultBlock) {
        this.defaultBlock = defaultBlock;
    }

    public Block getBaseBlock() {
        if (this.baseEntry != null) {
            return this.baseEntry.getBlock();
        }
        return this.defaultBlock;
    }

    public static Builder builder(String name, List<BlockVariant> variants) {
        return new Builder(name, variants);
    }

    public static Builder builder(String name, BlockVariant ... variants) {
        return new Builder(name, List.of(variants));
    }

    public static class Builder {
        private String name;
        private List<BlockVariant> variants;
        private BlockBehaviour.Properties defaultProperty;
        private BlockBehaviour dummyBlockBehavior;
        private Multimap<BlockVariant, SchemaEntry> entries;

        private Builder(String name, List<BlockVariant> variants) {
            this.name = name;
            this.entries = MultimapBuilder.hashKeys((int)variants.size()).arrayListValues().build();
            this.variants = variants;
        }

        public Builder defaultProperty(BlockBehaviour.Properties defaultProperty) {
            this.defaultProperty = defaultProperty;
            this.dummyBlockBehavior = new BlockBehaviour(defaultProperty){

                public Item m_5456_() {
                    return null;
                }

                protected Block m_7374_() {
                    return null;
                }
            };
            for (BlockVariant variant : this.variants) {
                for (BlockForm form : variant.getForms()) {
                    this.entries.put((Object)variant, (Object)new SchemaEntry(this.name, variant, form, defaultProperty));
                }
            }
            return this;
        }

        public Builder setProperty(BlockVariant variant, BlockBehaviour.Properties property) {
            this.entries.get((Object)variant).forEach(entry -> {
                entry.property = property;
            });
            return this;
        }

        public Builder setProperty(BlockForm form, BlockBehaviour.Properties property) {
            this.entries.values().stream().filter(entry -> entry.form == form).forEach(entry -> {
                entry.property = property;
            });
            return this;
        }

        public Builder setProperty(BlockVariant variant, BlockForm form, BlockBehaviour.Properties property) {
            this.entries.get((Object)variant).stream().filter(entry -> entry.form == form).forEach(entry -> {
                entry.property = property;
            });
            return this;
        }

        public Builder createProperties() {
            this.entries.values().forEach(entry -> {
                BlockForm form = entry.form;
                BlockVariant variant = entry.variant;
                if (form instanceof Forms.OreForm) {
                    entry.property = this.newProperty().m_60913_(3.0f, 3.0f);
                } else if (variant == Variants.COBBLED || variant == Variants.MOSSY_COBBLED) {
                    entry.property = this.newProperty().m_60913_(2.0f, 6.0f);
                } else if (form == Forms.REGOLITH) {
                    entry.property = this.newProperty().m_60978_(0.6f).m_60918_(SoundType.f_56739_);
                } else if (form == Forms.GRASSY_REGOLITH) {
                    entry.property = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50440_);
                } else if (form == Forms.BUTTON) {
                    entry.property = BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f);
                } else if (form == Forms.PRESSURE_PLATE) {
                    entry.property = this.newProperty().m_60910_().m_60978_(0.5f);
                }
            });
            return this;
        }

        private BlockBehaviour.Properties newProperty() {
            return BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.dummyBlockBehavior);
        }

        public BlockSchema build() {
            this.createProperties();
            return new BlockSchema(this.name, this.entries);
        }
    }
}

