/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.block.schema;

import java.util.ArrayList;
import java.util.List;
import lilypuree.unearthed.block.schema.BlockSchema;
import lilypuree.unearthed.block.schema.BlockVariant;
import lilypuree.unearthed.block.schema.Forms;
import lilypuree.unearthed.block.schema.Variants;
import lilypuree.unearthed.platform.Services;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BlockSchemas {
    private static float stoneHardness = 1.5f;
    private static float cobbleHardness = 2.0f;
    private static float stoneResistance = 6.0f;
    private static float miscResistance = 0.5f;
    private static BlockBehaviour.Properties stoneProperty = BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(stoneHardness, stoneResistance);
    private static final SoundType OVERGROWN_SOUND = Services.PLATFORM.createSoundType(1.0f, 1.0f, () -> SoundEvents.f_12442_, () -> SoundEvents.f_11992_, () -> SoundEvents.f_12447_, () -> SoundEvents.f_12446_, () -> SoundEvents.f_11989_);
    public static List<BlockSchema> ROCK_TYPES = new ArrayList<BlockSchema>();
    public static final BlockSchema PHYLLITE;
    public static final BlockSchema SLATE;
    public static final BlockSchema GABBRO;
    public static final BlockSchema GRANODIORITE;
    public static final BlockSchema RHYOLITE;
    public static final BlockSchema WHITE_GRANITE;
    public static final BlockSchema LIMESTONE;
    public static final BlockSchema BEIGE_LIMESTONE;
    public static final BlockSchema GREY_LIMESTONE;
    public static final BlockSchema SILTSTONE;
    public static final BlockSchema MUDSTONE;
    public static final BlockSchema CONGLOMERATE;
    public static final BlockSchema DACITE;
    public static final BlockSchema SCHIST;
    public static final BlockSchema WEATHERED_RHYOLITE;
    public static final BlockSchema PILLOW_BASALT;
    public static final BlockSchema DOLERITE;
    public static final BlockSchema LIGNITE;
    public static final BlockSchema QUARTZITE;
    public static final BlockSchema GRANITE;
    public static final BlockSchema DIORITE;
    public static final BlockSchema ANDESITE;
    public static final BlockSchema SANDSTONE;
    public static final BlockSchema STONE;

    private static BlockSchema register(String name, List<BlockVariant> variants) {
        return BlockSchemas.register(name, variants, stoneProperty);
    }

    private static BlockSchema registerSand(String name, List<BlockVariant> variants) {
        return BlockSchemas.register(name, variants, BlockSchemas.sandStone());
    }

    private static BlockSchema registerIntrusive(String name, List<BlockVariant> variants, Block defaultBlock) {
        BlockSchema schema = BlockSchema.builder(name, variants).defaultProperty(BlockBehaviour.Properties.m_60926_((BlockBehaviour)defaultBlock)).setProperty(Forms.OVERGROWN_ROCK, BlockBehaviour.Properties.m_60926_((BlockBehaviour)defaultBlock).m_60977_().m_60918_(OVERGROWN_SOUND)).build();
        schema.setDefaultBlock(defaultBlock);
        ROCK_TYPES.add(schema);
        return schema;
    }

    private static BlockSchema registerDefault(String name, List<BlockVariant> variants, Block defaultBlock) {
        BlockSchema schema = BlockSchemas.register(name, variants, BlockBehaviour.Properties.m_60926_((BlockBehaviour)defaultBlock));
        schema.setDefaultBlock(defaultBlock);
        return schema;
    }

    private static BlockSchema register(String name, List<BlockVariant> variants, BlockBehaviour.Properties prop) {
        BlockSchema schema = BlockSchema.builder(name, variants).defaultProperty(prop).build();
        ROCK_TYPES.add(schema);
        return schema;
    }

    private static List<BlockVariant> create(BlockVariant ... variants) {
        return List.of(variants);
    }

    private static BlockBehaviour.Properties stone() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_);
    }

    private static BlockBehaviour.Properties sandStone() {
        return BlockBehaviour.Properties.m_284310_().m_60999_().m_60978_(0.8f);
    }

    static {
        List<BlockVariant> basic = BlockSchemas.create(Variants.BASIC);
        List<BlockVariant> stone_like = BlockSchemas.create(Variants.ALL_BLOCKS_PLUS, Variants.COBBLED, Variants.MOSSY_COBBLED, Variants.BRICKS, Variants.MOSSY_BRICKS, Variants.CRACKED_BRICKS, Variants.CHISELED_BRICKS);
        List<BlockVariant> blackstone_like = BlockSchemas.create(Variants.ALL_BLOCKS_PLUS, Variants.POLISHED, Variants.POLISHED_BRICKS, Variants.CHISELED_POLISHED, Variants.CRACKED_POLISHED_BRICKS);
        List<BlockVariant> basalt_like = BlockSchemas.create(Variants.PILLAR, Variants.POLISHED_PILLAR);
        List<BlockVariant> sandstone_like = BlockSchemas.create(Variants.SEDIMENTARY, Variants.SMOOTH, Variants.CUT, Variants.CHISELED);
        List<BlockVariant> mudstone = BlockSchemas.create(Variants.SEDIMENTARY, Variants.CUT, Variants.CHISELED_FULL);
        List<BlockVariant> secondary = BlockSchemas.create(Variants.ALL_BASE_BLOCKS, Variants.POLISHED);
        List<BlockVariant> decorative = BlockSchemas.create(Variants.BASIC);
        List<BlockVariant> schist = BlockSchemas.create(Variants.SCHIST);
        List<BlockVariant> limestone = BlockSchemas.create(Variants.ALL_BASE_BLOCKS, Variants.COBBLED, Variants.BRICKS, Variants.PILLAR_BLOCK, Variants.CHISELED_FULL);
        List<BlockVariant> beige_limestone = BlockSchemas.create(Variants.SEDIMENTARY, Variants.COBBLED, Variants.BRICKS, Variants.PILLAR_BLOCK, Variants.CHISELED);
        List<BlockVariant> intrusive = BlockSchemas.create(Variants.OVERGROWN);
        PHYLLITE = BlockSchemas.register("phyllite", stone_like);
        SLATE = BlockSchemas.register("slate", stone_like);
        GABBRO = BlockSchemas.register("gabbro", blackstone_like);
        GRANODIORITE = BlockSchemas.register("granodiorite", blackstone_like);
        RHYOLITE = BlockSchemas.register("rhyolite", blackstone_like);
        WHITE_GRANITE = BlockSchemas.register("white_granite", blackstone_like);
        LIMESTONE = BlockSchemas.register("limestone", limestone);
        BEIGE_LIMESTONE = BlockSchemas.register("beige_limestone", beige_limestone);
        GREY_LIMESTONE = BlockSchemas.register("grey_limestone", limestone);
        SILTSTONE = BlockSchemas.registerSand("siltstone", sandstone_like);
        MUDSTONE = BlockSchemas.registerSand("mudstone", mudstone);
        CONGLOMERATE = BlockSchemas.registerSand("conglomerate", secondary);
        QUARTZITE = BlockSchemas.register("quartzite", basic);
        WEATHERED_RHYOLITE = BlockSchemas.register("weathered_rhyolite", basic);
        DOLERITE = BlockSchemas.register("dolerite", basic);
        SCHIST = BlockSchemas.register("schist", schist);
        LIGNITE = BlockSchemas.registerSand("lignite", decorative);
        PILLOW_BASALT = BlockSchemas.register("pillow_basalt", basic, BlockSchemas.stone().m_60913_(3.0f, 6.0f));
        DACITE = BlockSchemas.register("dacite", basalt_like, BlockSchemas.stone().m_60913_(1.25f, 4.2f).m_60918_(SoundType.f_56718_));
        GRANITE = BlockSchemas.registerIntrusive("granite", intrusive, Blocks.f_50122_);
        DIORITE = BlockSchemas.registerIntrusive("diorite", intrusive, Blocks.f_50228_);
        ANDESITE = BlockSchemas.registerIntrusive("andesite", intrusive, Blocks.f_50334_);
        SANDSTONE = BlockSchemas.registerDefault("sandstone", List.of(Variants.SANDSTONE), Blocks.f_50062_);
        STONE = BlockSchemas.registerDefault("stone", List.of(Variants.REGOLITHS), Blocks.f_50069_);
    }
}

