/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.block.schema;

import com.google.common.collect.Lists;
import java.util.List;
import lilypuree.unearthed.block.schema.BlockForm;

public class BlockVariant {
    private String name;
    private List<BlockForm> forms;
    private boolean derivative = false;
    private boolean isSideTop = false;

    public BlockVariant(String name, List<BlockForm> forms) {
        this.name = name;
        this.forms = forms;
    }

    public BlockVariant(String name, BlockForm ... forms) {
        this.name = name;
        this.forms = Lists.newArrayList((Object[])forms);
    }

    public String getName() {
        return this.name;
    }

    public List<BlockForm> getForms() {
        return this.forms;
    }

    public BlockVariant setDerivative() {
        this.derivative = true;
        return this;
    }

    public BlockVariant sideTop() {
        this.isSideTop = true;
        return this;
    }

    public boolean isSideTop() {
        return this.isSideTop;
    }

    public boolean isDerivative() {
        return this.derivative;
    }

    public boolean isBaseVariant() {
        return this.name.equals("");
    }

    public String getBlockId(String baseName, String suffix) {
        if (!this.name.equals("")) {
            baseName = this.name + "_" + (String)baseName;
        }
        if (!suffix.equals("")) {
            baseName = (String)baseName + "_" + suffix;
        }
        return baseName;
    }
}

