/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.block.schema;

import lilypuree.unearthed.block.schema.BlockForm;
import lilypuree.unearthed.block.schema.BlockSchema;
import lilypuree.unearthed.block.schema.BlockVariant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class SchemaEntry {
    protected String id;
    protected BlockVariant variant;
    protected BlockForm form;
    protected BlockBehaviour.Properties property;
    protected Block block;

    public SchemaEntry(String name, BlockVariant variant, BlockForm form, BlockBehaviour.Properties property) {
        this.id = variant.getBlockId(name, form.getName());
        this.property = property;
        this.variant = variant;
        this.form = form;
    }

    public Block createBlock(BlockSchema schema) {
        this.block = this.form.getBlockCreator(schema, this.variant).apply(this.property);
        return this.block;
    }

    public String getId() {
        return this.id;
    }

    public BlockForm getForm() {
        return this.form;
    }

    public BlockVariant getVariant() {
        return this.variant;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isBaseEntry() {
        return this.variant.isBaseVariant() && this.form.isBaseForm();
    }
}

