/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.client;

import lilypuree.unearthed.block.properties.ModBlockProperties;
import lilypuree.unearthed.block.schema.BlockForm;
import lilypuree.unearthed.block.schema.BlockSchema;
import lilypuree.unearthed.block.schema.BlockSchemas;
import lilypuree.unearthed.block.schema.Forms;
import lilypuree.unearthed.block.schema.SchemaEntry;
import lilypuree.unearthed.client.LichenColors;
import lilypuree.unearthed.core.Registration;
import lilypuree.unearthed.platform.Services;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ClientCommon {
    public static void initRenderLayers() {
        for (BlockSchema type : BlockSchemas.ROCK_TYPES) {
            for (SchemaEntry entry : type.entries()) {
                BlockForm form = entry.getForm();
                if (!(form instanceof Forms.OreForm) && form != Forms.GRASSY_REGOLITH && form != Forms.OVERGROWN_ROCK) continue;
                Services.PLATFORM.setRenderLayer(entry.getBlock(), RenderType.m_110457_());
            }
        }
        Services.PLATFORM.setRenderLayer((Block)Registration.LICHEN.get(), RenderType.m_110457_());
    }

    public static void blockColors() {
        for (BlockSchema type : BlockSchemas.ROCK_TYPES) {
            for (SchemaEntry entry : type.entries()) {
                BlockForm form = entry.getForm();
                if (form != Forms.GRASSY_REGOLITH && form != Forms.OVERGROWN_ROCK) continue;
                Services.PLATFORM.setBlockColor(entry.getBlock(), (blockstate, reader, pos, i) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0));
            }
        }
        Services.PLATFORM.setBlockColor((Block)Registration.LICHEN.get(), (blockstate, reader, pos, i) -> reader != null && pos != null ? LichenColors.shiftSaturation(reader.m_6171_(pos, LichenColors.LICHEN_COLOR), pos, (Boolean)blockstate.m_61143_((Property)ModBlockProperties.WET)) : LichenColors.getLichen());
    }

    public static void itemColors() {
        for (BlockSchema type : BlockSchemas.ROCK_TYPES) {
            for (SchemaEntry entry : type.entries()) {
                BlockForm form = entry.getForm();
                if (form != Forms.GRASSY_REGOLITH && form != Forms.OVERGROWN_ROCK) continue;
                Services.PLATFORM.setItemColor((ItemLike)entry.getBlock(), (stack, color) -> {
                    BlockState blockState = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
                    return Services.PLATFORM.getBlockColor(blockState, color);
                });
            }
        }
        Services.PLATFORM.setItemColor((ItemLike)Registration.LICHEN_ITEM.get(), (stack, color) -> LichenColors.getLichen());
    }
}

