/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.core;

import java.util.Objects;
import lilypuree.unearthed.Constants;
import lilypuree.unearthed.block.LichenBlock;
import lilypuree.unearthed.block.schema.BlockSchema;
import lilypuree.unearthed.block.schema.BlockSchemas;
import lilypuree.unearthed.misc.BlockStatePropertiesMatch;
import lilypuree.unearthed.misc.HoeDig;
import lilypuree.unearthed.misc.RegolithItem;
import lilypuree.unearthed.platform.ForgePlatformHelper;
import lilypuree.unearthed.platform.Services;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GravelBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Registration {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"unearthed");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"unearthed");
    public static DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"unearthed");
    public static final RegistryObject<Block> LICHEN = BLOCKS.register("lichen", () -> new LichenBlock(BlockBehaviour.Properties.m_284310_().m_60955_().m_60977_().m_60978_(0.2f).m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> PYROXENE = BLOCKS.register("pyroxene", () -> new GravelBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.6f).m_60918_(SoundType.f_56739_)));
    public static final RegistryObject<Block> LIGNITE_BRIQUETTES = BLOCKS.register("lignite_briquettes", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50353_)));
    public static final CreativeModeTab tab = Services.PLATFORM.createModTab("general", () -> new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"unearthed", (String)"chiseled_limestone")))));
    public static RegistryObject<CreativeModeTab> modeTab = CREATIVE_TABS.register("general", () -> tab);
    public static final RegistryObject<Item> PYROXENE_ITEM = ITEMS.register("pyroxene", () -> new BlockItem((Block)PYROXENE.get(), new Item.Properties().m_41486_()));
    public static final RegistryObject<Item> IRON_ORE = ITEMS.register("iron_ore", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> GOLD_ORE = ITEMS.register("gold_ore", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> REGOLITH = ITEMS.register("regolith", () -> new RegolithItem(new Item.Properties()));
    public static final RegistryObject<Item> LICHEN_ITEM = ITEMS.register("lichen", () -> new BlockItem((Block)LICHEN.get(), new Item.Properties()));
    public static final RegistryObject<Item> LIGNITE_BRIQUETTES_ITEM = ITEMS.register("lignite_briquettes", () -> new BlockItem((Block)LIGNITE_BRIQUETTES.get(), new Item.Properties()));

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        Registration.registerBlocks();
        Registration.registerItems();
        CREATIVE_TABS.register(bus);
    }

    public static void registerBlocks() {
        Constants.LOG.debug("UE: Registering blocks...");
        BlockSchemas.ROCK_TYPES.forEach(schema -> schema.entries().forEach(entry -> {
            RegistryObject block = BLOCKS.register(entry.getId(), () -> entry.createBlock((BlockSchema)schema));
        }));
        Constants.LOG.info("UE: Blocks registered!");
    }

    public static void registerItems() {
        Constants.LOG.debug("UE: Registering items...");
        Item.Properties properties = new Item.Properties();
        BlockSchemas.ROCK_TYPES.forEach(schema -> schema.entries().forEach(entry -> {
            RegistryObject item = ITEMS.register(entry.getId(), () -> new BlockItem(entry.getBlock(), properties));
            ForgePlatformHelper.addToMainTabItems(item);
        }));
        ForgePlatformHelper.addToMainTabItems(PYROXENE_ITEM);
        ForgePlatformHelper.addToMainTabItems(IRON_ORE);
        ForgePlatformHelper.addToMainTabItems(GOLD_ORE);
        ForgePlatformHelper.addToMainTabItems(REGOLITH);
        ForgePlatformHelper.addToMainTabItems(LICHEN_ITEM);
        ForgePlatformHelper.addToMainTabItems(LIGNITE_BRIQUETTES_ITEM);
        Constants.LOG.info("UE: Items registered!");
    }

    public static void registerLootConditions(IEventBus bus) {
        HoeDig.init(bus);
        BlockStatePropertiesMatch.init();
    }
}

