/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.misc;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import lilypuree.unearthed.misc.HoeDig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BlockStatePropertiesMatch
implements LootItemCondition {
    public static RegistryObject<LootItemConditionType> BLOCK_STATE_PROPERTIES_MATCH = HoeDig.LOOT_CONDITIONS.register("block_state_properties_match", () -> new LootItemConditionType((Serializer)new BSPSerializer()));
    private final Block block;
    private final String propertyNameA;
    private final String propertyNameB;

    public static void init() {
    }

    public BlockStatePropertiesMatch(Block block, String propertyNameA, String propertyNameB) {
        this.block = block;
        this.propertyNameA = propertyNameA;
        this.propertyNameB = propertyNameB;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81461_);
    }

    public boolean test(LootContext lootContext) {
        BlockState blockState = (BlockState)lootContext.m_78953_(LootContextParams.f_81461_);
        if (blockState != null && this.block == blockState.m_60734_()) {
            StateDefinition container = blockState.m_60734_().m_49965_();
            Property propertyA = container.m_61081_(this.propertyNameA);
            Property propertyB = container.m_61081_(this.propertyNameB);
            if (propertyA != null && propertyB != null) {
                return blockState.m_61143_(propertyA).equals(blockState.m_61143_(propertyB));
            }
        }
        return false;
    }

    public static Builder builder(Block blockIn) {
        return new Builder(blockIn);
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)BLOCK_STATE_PROPERTIES_MATCH.get();
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Block block;
        private String propertyNameA;
        private String propertyNameB;

        public Builder(Block blockIn) {
            this.block = blockIn;
        }

        public Builder propertiesToCompare(Property<?> propertyA, Property<?> propertyB) {
            this.propertyNameA = propertyA.m_61708_();
            this.propertyNameB = propertyB.m_61708_();
            return this;
        }

        public LootItemCondition m_6409_() {
            return new BlockStatePropertiesMatch(this.block, this.propertyNameA, this.propertyNameB);
        }
    }

    public static class BSPSerializer
    implements Serializer<BlockStatePropertiesMatch> {
        public void serialize(JsonObject jsonObject, BlockStatePropertiesMatch lootCondition, JsonSerializationContext context) {
            jsonObject.addProperty("block", ForgeRegistries.BLOCKS.getKey((Object)lootCondition.block).toString());
            jsonObject.addProperty("propertyA", lootCondition.propertyNameA);
            jsonObject.addProperty("propertyB", lootCondition.propertyNameB);
        }

        public BlockStatePropertiesMatch deserialize(JsonObject jsonObject, JsonDeserializationContext context) {
            ResourceLocation resourcelocation = ResourceLocation.parse((String)GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block"));
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourcelocation);
            String nameA = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"propertyA");
            String nameB = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"propertyB");
            return new BlockStatePropertiesMatch(block, nameA, nameB);
        }
    }
}

