/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.platform;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lilypuree.unearthed.platform.services.IPlatformHelper;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.registries.RegistryObject;

public class ForgePlatformHelper
implements IPlatformHelper {
    public static BlockColors blockColors;
    public static ItemColors itemColors;
    public static final List<Supplier<? extends ItemLike>> MAIN_BLOCKS;
    public static final List<Supplier<? extends ItemLike>> MAIN_ITEMS;

    @Override
    public CreativeModeTab createModTab(String name, Supplier<ItemStack> icon) {
        return CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)("itemGroup.unearthed." + name))).m_257737_(icon).m_257501_((pParameters, pOutput) -> {
            MAIN_BLOCKS.forEach(itemLike -> pOutput.m_246326_((ItemLike)itemLike.get()));
            MAIN_ITEMS.forEach(itemLike -> pOutput.m_246326_((ItemLike)itemLike.get()));
        }).m_257652_();
    }

    @Override
    public SoundType createSoundType(float volumeIn, float pitchIn, Supplier<SoundEvent> breakSoundIn, Supplier<SoundEvent> stepSoundIn, Supplier<SoundEvent> placeSoundIn, Supplier<SoundEvent> hitSoundIn, Supplier<SoundEvent> fallSoundIn) {
        return new ForgeSoundType(volumeIn, pitchIn, breakSoundIn, stepSoundIn, placeSoundIn, hitSoundIn, fallSoundIn);
    }

    @Override
    public void setRenderLayer(Block block, RenderType renderType) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
    }

    @Override
    public void setBlockColor(Block block, BlockColor blockColor) {
        blockColors.m_92589_(blockColor, new Block[]{block});
    }

    @Override
    public int getBlockColor(BlockState block, int color) {
        return blockColors.m_92577_(block, (BlockAndTintGetter)null, (BlockPos)null, color);
    }

    @Override
    public void setItemColor(ItemLike item, ItemColor itemColor) {
        itemColors.m_92689_(itemColor, new ItemLike[]{item});
    }

    @Override
    public boolean isDiggingHoe(ItemStack item) {
        return item.m_41720_().canPerformAction(item, ToolActions.HOE_DIG);
    }

    public static <T extends Item> RegistryObject<T> addToMainTab(RegistryObject<T> itemLike) {
        MAIN_BLOCKS.add((Supplier<? extends ItemLike>)itemLike);
        return itemLike;
    }

    public static <T extends Item> RegistryObject<T> addToMainTabItems(RegistryObject<T> itemLike) {
        MAIN_ITEMS.add((Supplier<? extends ItemLike>)itemLike);
        return itemLike;
    }

    static {
        MAIN_BLOCKS = new ArrayList<Supplier<? extends ItemLike>>();
        MAIN_ITEMS = new ArrayList<Supplier<? extends ItemLike>>();
    }
}

