/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.unearthed.util;

import net.minecraft.util.Mth;

public class ColorHelper {
    private static float getRed(int hex) {
        return (float)(hex >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int hex) {
        return (float)(hex >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int hex) {
        return (float)(hex & 0xFF) / 255.0f;
    }

    private static float getAlpha(int hex) {
        return (float)(hex >> 24 & 0xFF) / 255.0f;
    }

    public static float[] getARGB(int hex) {
        return new float[]{ColorHelper.getAlpha(hex), ColorHelper.getRed(hex), ColorHelper.getGreen(hex), ColorHelper.getBlue(hex)};
    }

    public static int toInt(float[] argb) {
        int r = (int)Math.floor(argb[1] * 255.0f) & 0xFF;
        int g = (int)Math.floor(argb[2] * 255.0f) & 0xFF;
        int b = (int)Math.floor(argb[3] * 255.0f) & 0xFF;
        int a = (int)Math.floor(argb[0] * 255.0f) & 0xFF;
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    private static float[] getAHSL(int hex) {
        return ColorHelper.ARGBtoAHSL(ColorHelper.getARGB(hex));
    }

    private static float[] getAHSV(int hex) {
        return ColorHelper.ARGBtoAHSV(ColorHelper.getARGB(hex));
    }

    private static float[] AHSLtoARGB(float[] ahsl) {
        return new float[]{ahsl[0], ColorHelper.convFunction(ahsl, 0), ColorHelper.convFunction(ahsl, 8), ColorHelper.convFunction(ahsl, 4)};
    }

    private static float convFunction(float[] ahsl, int n) {
        float k = ((float)n + ahsl[1] / 30.0f) % 12.0f;
        float a = ahsl[2] * Math.min(ahsl[3], 1.0f - ahsl[3]);
        return ahsl[3] - a * Math.max(-1.0f, Math.min(k - 3.0f, Math.min(9.0f - k, 1.0f)));
    }

    private static float[] AHSVtoARGB(float[] ahsv) {
        return new float[]{ahsv[0], ColorHelper.convFunction2(ahsv, 5), ColorHelper.convFunction2(ahsv, 3), ColorHelper.convFunction2(ahsv, 1)};
    }

    private static float convFunction2(float[] ahsv, int n) {
        float k = ((float)n + ahsv[1] / 60.0f) % 6.0f;
        return ahsv[3] - ahsv[3] * ahsv[2] * Math.max(0.0f, Math.min(k, Math.min(4.0f - k, 1.0f)));
    }

    private static float[] ARGBtoAHSL(float[] argb) {
        float r = argb[1];
        float g = argb[2];
        float b = argb[3];
        float value = Math.max(r, Math.max(g, b));
        float minX = Math.min(r, Math.min(g, b));
        float chroma = value - minX;
        float lightness = (value + minX) / 2.0f;
        float hue = ColorHelper.getHue(r, g, b, value, chroma);
        float saturationL = ColorHelper.getSaturationL(value, lightness);
        return new float[]{argb[0], hue, saturationL, lightness};
    }

    private static float[] ARGBtoAHSV(float[] argb) {
        float r = argb[1];
        float g = argb[2];
        float b = argb[3];
        float value = Math.max(r, Math.max(g, b));
        float minX = Math.min(r, Math.min(g, b));
        float chroma = value - minX;
        float hue = ColorHelper.getHue(r, g, b, value, chroma);
        float saturationV = ColorHelper.getSaturationV(value, chroma);
        return new float[]{argb[0], hue, saturationV, value};
    }

    private static float getHue(float r, float g, float b, float v, float c) {
        if (c == 0.0f) {
            return 0.0f;
        }
        if (v == r) {
            return 60.0f * (g - b) / c;
        }
        if (v == g) {
            return 60.0f * (2.0f + (b - r) / c);
        }
        return 60.0f * (4.0f + (r - g) / c);
    }

    private static float getSaturationL(float value, float lightness) {
        if (lightness == 0.0f || lightness == 1.0f) {
            return 0.0f;
        }
        return (value - lightness) / Math.min(lightness, 1.0f - lightness);
    }

    private static float getSaturationV(float value, float chroma) {
        if (value == 0.0f) {
            return 0.0f;
        }
        return chroma / value;
    }

    public static int blend(int color1, int color2, float ratio) {
        float ir = 1.0f - ratio;
        float[] rgb1 = ColorHelper.getARGB(color2);
        float[] rgb2 = ColorHelper.getARGB(color1);
        return ColorHelper.toInt(new float[]{rgb1[0] * ratio + rgb2[0] * ir, rgb1[1] * ratio + rgb2[1] * ir, rgb1[2] * ratio + rgb2[2] * ir, rgb1[3] * ratio + rgb2[3] * ir});
    }

    public static int shiftColorHSL(int color, float hueChange, float saturationChange, float luminanceChange) {
        float[] hsl = ColorHelper.getAHSL(color);
        return ColorHelper.toInt(ColorHelper.AHSLtoARGB(new float[]{hsl[0], (hsl[1] + hueChange) % 360.0f, Mth.m_14036_((float)(hsl[2] + saturationChange), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(hsl[3] + luminanceChange), (float)0.0f, (float)1.0f)}));
    }

    public static int shiftColorHSV(int color, float hueChange, float saturationChange, float valueChange) {
        float[] hsv = ColorHelper.getAHSV(color);
        return ColorHelper.toInt(ColorHelper.AHSVtoARGB(new float[]{hsv[0], (hsv[1] + hueChange) % 360.0f, Mth.m_14036_((float)(hsv[2] + saturationChange), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(hsv[3] + valueChange), (float)0.0f, (float)1.0f)}));
    }
}

