/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel;

import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.g_skyrim.rpglevel.config.RpgConfigLoader;
import org.g_skyrim.rpglevel.config.RpgGeneralConfig;
import org.g_skyrim.rpglevel.mixin.LootableContainerAccessor;
import org.g_skyrim.rpglevel.network.RpgNetwork;
import org.g_skyrim.rpglevel.player.PlayerSkills;
import org.g_skyrim.rpglevel.restrictions.RestrictionEngine;
import org.g_skyrim.rpglevel.skills.SkillDefinition;
import org.g_skyrim.rpglevel.skills.SkillRegistry;
import org.g_skyrim.rpglevel.util.RpgCommands;
import org.g_skyrim.rpglevel.util.RpgLogger;
import org.g_skyrim.rpglevel.util.SkillBenefits;

public class Rpglevel
implements ModInitializer {
    public static final String MOD_ID = "rpglevel";
    public static final class_2960 SK_MINING = new class_2960("rpglevel", "mining");
    public static final class_2960 SK_WOODCUTTING = new class_2960("rpglevel", "woodcutting");
    public static final class_2960 SK_FARMING = new class_2960("rpglevel", "farming");
    public static final class_2960 SK_FISHING = new class_2960("rpglevel", "fishing");
    public static final class_2960 SK_COMBAT = new class_2960("rpglevel", "combat");
    public static final class_2960 SK_ARCHERY = new class_2960("rpglevel", "archery");
    public static final class_2960 SK_DEFENSE = new class_2960("rpglevel", "defense");
    public static final class_2960 SK_CRAFTING = new class_2960("rpglevel", "crafting");
    public static final class_2960 SK_AGILITY = new class_2960("rpglevel", "agility");
    public static final class_2960 SK_ENDURANCE = new class_2960("rpglevel", "endurance");
    public static final class_2960 SK_HEALING = new class_2960("rpglevel", "healing");
    public static final class_2960 SK_LUCK = new class_2960("rpglevel", "luck");
    private static final class_6862<class_2248> PICKAXE = class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)new class_2960("minecraft", "mineable/pickaxe"));
    private static final class_6862<class_2248> AXE = class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)new class_2960("minecraft", "mineable/axe"));
    private static final Map<UUID, Integer> AGILITY_TICKS = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> LAST_JUMPS = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> LAST_FISH_CAUGHT = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> LAST_ENCHANTS = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> LAST_DMG_TAKEN = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> LAST_DMG_DEALT = new HashMap<UUID, Integer>();
    private static int SERVER_TICK = 0;
    private static final class_2960 STAT_JUMP = new class_2960("minecraft", "jump");
    private static final class_2960 STAT_DAMAGE_TAKEN = new class_2960("minecraft", "damage_taken");
    private static final class_2960 STAT_DAMAGE_DEALT = new class_2960("minecraft", "damage_dealt");

    public void onInitialize() {
        RpgLogger.info("Initializing rpglevel");
        PlayerSkills.bootstrap();
        SkillRegistry.bootstrap();
        RestrictionEngine.bootstrap();
        RpgNetwork.registerServerReceivers();
        RpgConfigLoader.setConfigDir(FabricLoader.getInstance().getConfigDir());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)RpgConfigLoader.getDatapackReloadListener());
        RpgConfigLoader.initialLoad(FabricLoader.getInstance().getConfigDir());
        ServerLifecycleEvents.SERVER_STARTED.register(server -> PlayerSkills.clearRuntimeCache());
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> PlayerSkills.clearRuntimeCache());
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            try {
                if (handler.field_14140 != null) {
                    RpgNetwork.sendSnapshot(handler.field_14140);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.registerGameplayEvents();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> RpgCommands.register((CommandDispatcher<class_2168>)dispatcher));
        RpgLogger.info("rpglevel initialized.");
    }

    private void registerGameplayEvents() {
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> RestrictionEngine.get().onBlockBreak(world, player, state));
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            class_6880 entry;
            if (world.field_9236 || !(player instanceof class_3222)) {
                return;
            }
            class_3222 sp = (class_3222)player;
            class_2248 b = state.method_26204();
            if (b instanceof class_2302) {
                class_2302 crop = (class_2302)b;
                try {
                    if (crop.method_9825(state)) {
                        class_1792 extra;
                        Rpglevel.awardXp(sp, SK_FARMING, RpgGeneralConfig.get().xp.farmingMatureCropXp);
                        int lvl = PlayerSkills.of(sp.method_5667()).getLevel(SK_FARMING);
                        double max = RpgGeneralConfig.get().benefits.farmingExtraDropChanceMax;
                        int maxLvl = SkillRegistry.get(SK_FARMING).map(def -> def.maxLevel()).orElse(50);
                        double perLvl = maxLvl > 0 ? max / (double)maxLvl : 0.0;
                        double chance = Math.min(max, (double)lvl * perLvl);
                        if (chance > 0.0 && world.method_8409().method_43058() < chance && (extra = b.method_8389()) != null && extra != class_1802.field_8162) {
                            class_1799 bonus = new class_1799((class_1935)extra, 1);
                            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)bonus);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((entry = class_7923.field_41175.method_47983((Object)b)) != null && entry.method_40220(AXE)) {
                Rpglevel.awardXp(sp, SK_WOODCUTTING, RpgGeneralConfig.get().xp.woodcuttingPerLogXp);
            } else if (entry != null && entry.method_40220(PICKAXE)) {
                Rpglevel.awardXp(sp, SK_MINING, RpgGeneralConfig.get().xp.miningPerBlockXp);
                if (b == class_2246.field_10013 || b == class_2246.field_29220) {
                    Rpglevel.awardXp(sp, SK_LUCK, RpgGeneralConfig.get().xp.luckMiningEmeraldOreXp);
                }
            }
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1271<class_1799> res = RestrictionEngine.get().onUseItem(player, world, hand);
            if (!world.field_9236 && res.method_5467().method_23665() && player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                class_1792 item = ((class_1799)res.method_5466()).method_7909();
                if (item instanceof class_1753 || item instanceof class_1764) {
                    Rpglevel.awardXp(sp, SK_ARCHERY, RpgGeneralConfig.get().xp.archeryUseBowXp);
                    Rpglevel.awardXp(sp, SK_COMBAT, RpgGeneralConfig.get().xp.combatRangedUseXp);
                } else if (item instanceof class_1812) {
                    Rpglevel.awardXp(sp, SK_CRAFTING, RpgGeneralConfig.get().xp.craftingDrinkPotionXp);
                }
                if (((class_1799)res.method_5466()).method_19267()) {
                    Rpglevel.awardXp(sp, SK_ENDURANCE, RpgGeneralConfig.get().xp.enduranceEatFoodXp);
                }
            }
            return res;
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> RestrictionEngine.get().onAttackBlock(player, world, hand, pos, direction));
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> RestrictionEngine.get().onAttackEntity(player, world, hand, entity, hitResult));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_1269 gate = RestrictionEngine.get().onUseBlock(player, world, hand, hitResult.method_17777());
            if (gate != class_1269.field_5811) {
                return gate;
            }
            if (!world.field_9236 && player instanceof class_3222) {
                class_2586 be;
                class_3222 sp = (class_3222)player;
                class_1799 held = player.method_5998(hand);
                if (held.method_7909() instanceof class_1794 && world.method_8409().method_43057() < (float)RpgGeneralConfig.get().xp.farmingHoeTillChance) {
                    Rpglevel.awardXp(sp, SK_FARMING, RpgGeneralConfig.get().xp.farmingHoeTillXp);
                }
                if ((be = world.method_8321(hitResult.method_17777())) instanceof class_2621) {
                    class_2621 lbe = (class_2621)be;
                    try {
                        class_2960 lt = ((LootableContainerAccessor)lbe).getLootTableId();
                        if (lt != null) {
                            this.awardRandomXpRange(sp, SK_LUCK, RpgGeneralConfig.get().xp.luckOpenLootContainerMin, RpgGeneralConfig.get().xp.luckOpenLootContainerMax);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return class_1269.field_5811;
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            int mod5 = ++SERVER_TICK % 5;
            List players = server.method_3760().method_14571();
            for (class_3222 sp : players) {
                int lastDd;
                int delta;
                int per;
                long gain;
                boolean moving;
                SkillBenefits.apply(sp);
                try {
                    for (class_1304 slot : new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166, class_1304.field_6171}) {
                        this.enforceEquipRestriction(sp, slot);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                UUID idp = sp.method_5667();
                boolean bl = moving = sp.method_5624() || sp.method_18798().method_37268() > 0.001;
                if (moving) {
                    int t = AGILITY_TICKS.getOrDefault(idp, 0) + 1;
                    if (t >= 20) {
                        Rpglevel.awardXp(sp, SK_AGILITY, RpgGeneralConfig.get().xp.agilityPerSecondMovingXp);
                        t -= 20;
                    }
                    AGILITY_TICKS.put(idp, t);
                } else {
                    AGILITY_TICKS.putIfAbsent(idp, 0);
                }
                int jumps = Rpglevel.getCustom(sp, STAT_JUMP);
                int deltaJ = this.getDeltaAndUpdate(LAST_JUMPS, idp, jumps);
                if (deltaJ > 0 && (gain = (long)deltaJ * (long)(per = Math.max(0, RpgGeneralConfig.get().xp.endurancePerJumpXp))) > 0L) {
                    Rpglevel.awardXp(sp, SK_ENDURANCE, gain);
                }
                if (mod5 == 0) {
                    int lastF;
                    int fish = Rpglevel.getCustom(sp, class_3468.field_15391);
                    if (fish > (lastF = LAST_FISH_CAUGHT.getOrDefault(idp, fish).intValue())) {
                        int deltaCatches = fish - lastF;
                        class_5819 rng = sp.method_6051();
                        long total = 0L;
                        for (int i = 0; i < deltaCatches; ++i) {
                            int min = Math.max(0, RpgGeneralConfig.get().xp.fishingPerCatchMin);
                            int max = Math.max(min, RpgGeneralConfig.get().xp.fishingPerCatchMax);
                            total += (long)(min + rng.method_43048(max - min + 1));
                        }
                        Rpglevel.awardXp(sp, SK_FISHING, total);
                        LAST_FISH_CAUGHT.put(idp, fish);
                    } else if (!LAST_FISH_CAUGHT.containsKey(idp)) {
                        LAST_FISH_CAUGHT.put(idp, fish);
                    }
                }
                if (mod5 == 1) {
                    int lastE;
                    int ench = Rpglevel.getCustom(sp, class_3468.field_15420);
                    if (ench > (lastE = LAST_ENCHANTS.getOrDefault(idp, ench).intValue())) {
                        Rpglevel.awardXp(sp, SK_CRAFTING, ench - lastE);
                        LAST_ENCHANTS.put(idp, ench);
                    } else if (!LAST_ENCHANTS.containsKey(idp)) {
                        LAST_ENCHANTS.put(idp, ench);
                    }
                }
                if (mod5 == 2) {
                    int lastDt;
                    int dt = Rpglevel.getCustom(sp, STAT_DAMAGE_TAKEN);
                    if (dt > (lastDt = LAST_DMG_TAKEN.getOrDefault(idp, dt).intValue())) {
                        delta = dt - lastDt;
                        int div = Math.max(1, RpgGeneralConfig.get().xp.defensePerDamageTakenDivisor);
                        long def = Math.max(1, delta / div);
                        Rpglevel.awardXp(sp, SK_DEFENSE, def);
                        LAST_DMG_TAKEN.put(idp, dt);
                    } else if (!LAST_DMG_TAKEN.containsKey(idp)) {
                        LAST_DMG_TAKEN.put(idp, dt);
                    }
                }
                if (mod5 != 3) continue;
                int dd = Rpglevel.getCustom(sp, STAT_DAMAGE_DEALT);
                if (dd > (lastDd = LAST_DMG_DEALT.getOrDefault(idp, dd).intValue())) {
                    delta = dd - lastDd;
                    int div = Math.max(1, RpgGeneralConfig.get().xp.combatPerDamageDealtDivisor);
                    long comb = Math.max(1, delta / div);
                    Rpglevel.awardXp(sp, SK_COMBAT, comb);
                    LAST_DMG_DEALT.put(idp, dd);
                    continue;
                }
                if (LAST_DMG_DEALT.containsKey(idp)) continue;
                LAST_DMG_DEALT.put(idp, dd);
            }
        });
    }

    public static void awardXp(class_3222 sp, class_2960 skill, long amount) {
        if (sp == null || skill == null || amount == 0L) {
            return;
        }
        PlayerSkills ps = PlayerSkills.of(sp.method_5667());
        int before = ps.getLevel(skill);
        ps.addXp(skill, amount);
        int after = ps.getLevel(skill);
        Rpglevel.handleLevelChange(sp, skill, before, after);
    }

    public static void handleLevelChange(class_3222 sp, class_2960 skill, int before, int after) {
        if (sp == null) {
            return;
        }
        int[] thresholds = new int[]{5, 10, 15, 20, 25, 50};
        String[] ranks = new String[]{"novice", "apprentice", "adept", "expert", "master", "GOD"};
        for (int i = 0; i < thresholds.length; ++i) {
            int t = thresholds[i];
            if (before >= t || after < t) continue;
            Rpglevel.announceRank(sp, skill, ranks[i], i);
        }
        Rpglevel.checkAllSkillsMaxed(sp);
    }

    private static void announceRank(class_3222 sp, class_2960 skill, String rank, int rarityIndex) {
        class_124 color;
        boolean bold = false;
        switch (rarityIndex) {
            case 0: {
                color = class_124.field_1080;
                break;
            }
            case 1: {
                color = class_124.field_1060;
                break;
            }
            case 2: {
                color = class_124.field_1075;
                break;
            }
            case 3: {
                color = class_124.field_1076;
                break;
            }
            case 4: {
                color = class_124.field_1065;
                bold = true;
                break;
            }
            default: {
                color = class_124.field_1079;
                bold = true;
            }
        }
        class_5250 name = sp.method_5477().method_27661();
        class_5250 skillText = class_2561.method_43470((String)skill.method_12832());
        class_5250 rankText = class_2561.method_43470((String)rank);
        class_5250 styledRank = rankText.method_27661().method_27692(color);
        if (bold) {
            styledRank = styledRank.method_27692(class_124.field_1067);
        }
        class_5250 msg = class_2561.method_43470((String)"").method_10852((class_2561)name.method_27661().method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" is now a ")).method_10852((class_2561)styledRank).method_10852((class_2561)class_2561.method_43470((String)" in ")).method_10852((class_2561)skillText.method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"!"));
        MinecraftServer server = sp.method_5682();
        if (server != null) {
            for (class_3222 p : server.method_3760().method_14571()) {
                p.method_43496((class_2561)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAllSkillsMaxed(class_3222 sp) {
        PlayerSkills ps = PlayerSkills.of(sp.method_5667());
        if (ps == null) {
            return;
        }
        try {
            List<class_2960> ids = SkillRegistry.allIdsSnapshot();
            if (ids.isEmpty()) {
                return;
            }
            for (class_2960 id : ids) {
                Optional<SkillDefinition> defOpt = SkillRegistry.get(id);
                if (defOpt.isEmpty()) {
                    return;
                }
                SkillDefinition def = defOpt.get();
                if (ps.getLevel(id) >= def.maxLevel()) continue;
                return;
            }
        }
        catch (Throwable ignored) {
            return;
        }
        try {
            boolean already;
            Field f = PlayerSkills.class.getDeclaredField("allMaxAnnounced");
            f.setAccessible(true);
            PlayerSkills playerSkills = ps;
            synchronized (playerSkills) {
                already = (Boolean)f.get(ps);
                if (!already) {
                    f.set(ps, true);
                }
            }
            if (already) {
                return;
            }
        }
        catch (Throwable f) {
            // empty catch block
        }
        MinecraftServer server = sp.method_5682();
        if (server != null) {
            class_5250 msg = class_2561.method_43470((String)"").method_10852((class_2561)sp.method_5477().method_27661().method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" has mastered ALL skills and ascended to forge ")).method_10852((class_2561)class_2561.method_43470((String)"legends").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" in pixel and stone ")).method_10852((class_2561)class_2561.method_43470((String)"!"));
            for (class_3222 p : server.method_3760().method_14571()) {
                p.method_43496((class_2561)msg);
            }
        }
    }

    private static int getCustom(class_3222 sp, class_2960 statId) {
        if (statId == null) {
            return 0;
        }
        try {
            return sp.method_14248().method_15025(class_3468.field_15419.method_14956((Object)statId));
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private void returnItemToInventoryOrDrop(class_3222 sp, class_1799 toReturn) {
        if (toReturn == null || toReturn.method_7960()) {
            return;
        }
        boolean inserted = sp.method_31548().method_7394(toReturn);
        if (!inserted && !toReturn.method_7960()) {
            sp.method_7328(toReturn, true);
        }
    }

    private void enforceEquipRestriction(class_3222 sp, class_1304 slot) {
        class_1799 equipped = sp.method_6118(slot);
        if (equipped.method_7960()) {
            return;
        }
        if (!RestrictionEngine.get().onEquipItem(sp, slot, equipped)) {
            class_1799 toReturn = equipped.method_7972();
            sp.method_5673(slot, class_1799.field_8037);
            this.returnItemToInventoryOrDrop(sp, toReturn);
        }
    }

    private int randomInRange(class_3222 sp, int min, int max) {
        int a = Math.max(0, min);
        int b = Math.max(a, max);
        return a + sp.method_6051().method_43048(b - a + 1);
    }

    private void awardRandomXpRange(class_3222 sp, class_2960 skill, int min, int max) {
        Rpglevel.awardXp(sp, skill, this.randomInRange(sp, min, max));
    }

    private int getDeltaAndUpdate(Map<UUID, Integer> lastMap, UUID id, int current) {
        int last = lastMap.getOrDefault(id, current);
        lastMap.put(id, current);
        return Math.max(0, current - last);
    }
}

