/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.client.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_490;
import org.g_skyrim.rpglevel.client.RpglevelClient;
import org.g_skyrim.rpglevel.client.screen.IconButtonWidget;
import org.g_skyrim.rpglevel.client.screen.SkillDetailScreen;
import org.g_skyrim.rpglevel.clientcache.ClientSkillsCache;
import org.g_skyrim.rpglevel.network.RpgNetwork;

@Environment(value=EnvType.CLIENT)
public class SkillsScreen
extends class_437 {
    private final List<Entry> entries = new ArrayList<Entry>();

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_304 kb = RpglevelClient.getOpenSkillsKey();
        if (kb != null && kb.method_1417(keyCode, scanCode)) {
            class_310.method_1551().method_1507(null);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public SkillsScreen() {
        super((class_2561)class_2561.method_43473());
    }

    protected void method_25426() {
        super.method_25426();
        ClientPlayNetworking.send((class_2960)RpgNetwork.REQ_SNAPSHOT, (class_2540)PacketByteBufs.empty());
        this.method_37067();
        int btnX = this.field_22789 / 2 - 88 + 4;
        int btnY = this.field_22790 / 2 - 83 - 22;
        this.method_37063((class_364)new IconButtonWidget(btnX, btnY, 24, 24, new class_1799((class_1935)class_1802.field_8106), (class_2561)class_2561.method_43470((String)"Inventory"), b -> {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 != null) {
                mc.method_1507((class_437)new class_490((class_1657)mc.field_1724));
            }
        }));
        this.method_37063((class_364)new IconButtonWidget(btnX + 26, btnY, 24, 24, new class_1799((class_1935)class_1802.field_8529), (class_2561)class_2561.method_43470((String)"Skills"), b -> {}));
    }

    private static String prettyName(class_2960 id) {
        String path = id.method_12832().replace('_', ' ');
        if (path.isEmpty()) {
            return id.toString();
        }
        return Character.toUpperCase(path.charAt(0)) + path.substring(1);
    }

    private static class_1799 iconFor(class_2960 id) {
        return SkillDetailScreen.getItemStack(id);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        int rowHeight = 28;
        int topPadding = 16;
        int bottomPadding = 12;
        int vGap = 0;
        int rows = (this.entries.size() + 1) / 2;
        int colWidth = Math.min(240, Math.max(200, this.field_22789 / 2 - 40));
        int panelWidth = colWidth * 2 + 28;
        int panelHeight = topPadding + rows * rowHeight + bottomPadding;
        int panelLeft = (this.field_22789 - panelWidth) / 2;
        int panelTop = this.field_22790 / 2 - 83;
        int panelRight = panelLeft + panelWidth;
        int panelBottom = panelTop + panelHeight;
        SkillsScreen.fillRounded(context, panelLeft, panelTop, panelRight, panelBottom, -871362544);
        SkillsScreen.drawRoundedBorder(context, panelLeft, panelTop, panelRight, panelBottom, -12566464);
        int leftX = panelLeft + 10;
        int rightX = panelLeft + panelWidth - colWidth - 10;
        int top = panelTop + topPadding - 8 + vGap;
        int hoveredIndex = this.indexAt(mouseX, mouseY);
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.get(i);
            int col = i % 2;
            int row = i / 2;
            int baseX = col == 0 ? leftX : rightX;
            int rowY = top + row * rowHeight;
            if (i == hoveredIndex) {
                SkillsScreen.fillRounded(context, baseX, rowY, baseX + colWidth, rowY + rowHeight, 0x35FFFFFF);
                SkillsScreen.drawRoundedBorder(context, baseX, rowY, baseX + colWidth, rowY + rowHeight, -2009055168);
            }
            context.method_51427(SkillsScreen.iconFor(e.id), baseX, rowY);
            String header = SkillsScreen.prettyName(e.id) + "  Lvl " + e.level + "/" + e.max;
            float scaleH = 0.9f;
            context.method_51448().method_22903();
            context.method_51448().method_22905(scaleH, scaleH, 1.0f);
            int hx = (int)((float)(baseX + 22) / scaleH);
            int hy = (int)((float)(rowY + 2) / scaleH);
            context.method_25303(this.field_22793, header, hx, hy, 0xFFFFFF);
            context.method_51448().method_22909();
            boolean atMax = e.level >= e.max;
            long prev = e.prevReq;
            long next = Math.max(e.prevReq + 1L, e.nextReq);
            long cur = Math.max(e.prevReq, Math.min(e.xp, next));
            float pct = atMax ? 1.0f : (next == prev ? 1.0f : (float)(cur - prev) / (float)(next - prev));
            int barX = baseX + 22;
            int barY = rowY + 14;
            int barW = colWidth - 22 - 8;
            int barH = 8;
            SkillsScreen.roundedBar(context, barX, barY, barW, barH, -14671840);
            int fillW = (int)((float)barW * pct);
            int colorTop = atMax ? -2052096 : -13730510;
            SkillsScreen.roundedBar(context, barX, barY, Math.max(0, fillW), barH, colorTop);
            if (!atMax) {
                long curIn = Math.max(0L, Math.min(e.xp - prev, next - prev));
                long needIn = Math.max(1L, next - prev);
                String prog = curIn + "/" + needIn;
                this.drawScaledCenteredText(context, prog, barX, barY, barW, barH, 0.75f, -5197648);
                continue;
            }
            String prog = "max";
            this.drawScaledCenteredText(context, prog, barX, barY, barW, barH, 0.8f, -12961222);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int idx = this.indexAt(mouseX, mouseY);
        if (idx >= 0) {
            Entry e = this.entries.get(idx);
            class_310.method_1551().method_1507((class_437)new SkillDetailScreen(e.id));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private int indexAt(double mouseX, double mouseY) {
        int rowHeight = 28;
        int topPadding = 16;
        int colWidth = Math.min(240, Math.max(200, this.field_22789 / 2 - 40));
        int panelWidth = colWidth * 2 + 28;
        int panelLeft = (this.field_22789 - panelWidth) / 2;
        int panelTop = this.field_22790 / 2 - 83;
        int leftX = panelLeft + 10;
        int rightX = panelLeft + panelWidth - colWidth - 10;
        int top = panelTop + topPadding - 8;
        for (int i = 0; i < this.entries.size(); ++i) {
            int col = i % 2;
            int row = i / 2;
            int baseX = col == 0 ? leftX : rightX;
            int rowY = top + row * rowHeight;
            if (!(mouseX >= (double)baseX) || !(mouseX <= (double)(baseX + colWidth)) || !(mouseY >= (double)rowY) || !(mouseY <= (double)(rowY + rowHeight))) continue;
            return i;
        }
        return -1;
    }

    private static void roundedBar(class_332 ctx, int x, int y, int w, int h, int color) {
        if (w <= 0 || h <= 0) {
            return;
        }
        ctx.method_25294(x, y + 1, x + w, y + h - 1, color);
        ctx.method_25294(x + 1, y, x + Math.max(1, w - 1), y + 1, color);
        ctx.method_25294(x + 1, y + h - 1, x + Math.max(1, w - 1), y + h, color);
    }

    private static void fillRounded(class_332 ctx, int left, int top, int right, int bottom, int color) {
        ctx.method_25294(left, top + 2, right, bottom - 2, color);
        ctx.method_25294(left + 2, top, right - 2, top + 2, color);
        ctx.method_25294(left + 2, bottom - 2, right - 2, bottom, color);
    }

    private static void drawRoundedBorder(class_332 ctx, int left, int top, int right, int bottom, int color) {
        SkillDetailScreen.drawPanelLayout(ctx, left, top, right, bottom, color);
    }

    public void applySnapshot(List<Entry> list) {
        this.entries.clear();
        this.entries.addAll(list);
    }

    public static void handleSnapshotPacket(class_2540 buf) {
        class_310 mc = class_310.method_1551();
        buf.method_10816();
        int n = buf.method_10816();
        ArrayList<Entry> list = new ArrayList<Entry>(n);
        for (int i = 0; i < n; ++i) {
            class_2960 id = buf.method_10810();
            int lvl = buf.method_10816();
            long xp = buf.method_10792();
            int max = buf.method_10816();
            long prevReq = buf.method_10792();
            long nextReq = buf.method_10792();
            list.add(new Entry(id, lvl, xp, max, prevReq, nextReq));
        }
        mc.execute(() -> {
            HashMap<class_2960, Integer> levels = new HashMap<class_2960, Integer>();
            for (Entry e : list) {
                levels.put(e.id, e.level);
            }
            ClientSkillsCache.setSnapshot(levels);
            class_437 patt0$temp = mc.field_1755;
            if (patt0$temp instanceof SkillsScreen) {
                SkillsScreen screen = (SkillsScreen)patt0$temp;
                screen.applySnapshot(list);
            }
        });
    }

    private void drawScaledCenteredText(class_332 context, String text, int x, int y, int w, int h, float scale, int color) {
        int textPixelWidth = this.field_22793.method_1727(text);
        int progWidthScaled = Math.round((float)textPixelWidth * scale);
        int txUnscaled = x + w / 2 - progWidthScaled / 2;
        Objects.requireNonNull(this.field_22793);
        int fontH = 9;
        int scaledFontH = Math.round((float)fontH * scale);
        int tyUnscaled = y + (h - scaledFontH) / 2;
        context.method_51448().method_22903();
        context.method_51448().method_22905(scale, scale, 1.0f);
        int px = Math.round((float)txUnscaled / scale);
        int py = Math.round((float)tyUnscaled / scale);
        context.method_51433(this.field_22793, text, px, py, color, false);
        context.method_51448().method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    private static class Entry {
        class_2960 id;
        int level;
        long xp;
        int max;
        long prevReq;
        long nextReq;

        Entry(class_2960 id, int level, long xp, int max, long prevReq, long nextReq) {
            this.id = id;
            this.level = level;
            this.xp = xp;
            this.max = max;
            this.prevReq = prevReq;
            this.nextReq = nextReq;
        }
    }
}

