/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.g_skyrim.rpglevel.config.RpgGeneralConfig;
import org.g_skyrim.rpglevel.restrictions.RestrictionEngine;
import org.g_skyrim.rpglevel.restrictions.model.RestrictionRule;
import org.g_skyrim.rpglevel.skills.SkillDefinition;
import org.g_skyrim.rpglevel.skills.SkillRegistry;
import org.g_skyrim.rpglevel.util.RpgLogger;

public final class RpgConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path CONFIG_DIR;

    private RpgConfigLoader() {
    }

    public static void setConfigDir(Path configDir) {
        CONFIG_DIR = configDir;
    }

    public static SimpleSynchronousResourceReloadListener getDatapackReloadListener() {
        return new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("rpglevel", "datapack_loader");
            }

            public void method_14491(class_3300 manager) {
                try {
                    Path base;
                    Path path = base = CONFIG_DIR != null ? CONFIG_DIR.resolve("rpglevel") : null;
                    if (base != null) {
                        Files.createDirectories(base.resolve("skills"), new FileAttribute[0]);
                        Files.createDirectories(base.resolve("restrictions"), new FileAttribute[0]);
                    }
                    if (CONFIG_DIR != null) {
                        try {
                            RpgGeneralConfig.loadOrCreate(CONFIG_DIR);
                        }
                        catch (Exception e) {
                            RpgLogger.error("Failed to reload general.json from config", e);
                        }
                    }
                    List<SkillDefinition> dpSkills = DataPackReaders.readSkillsFromDataPacks(manager);
                    List<RestrictionRule> dpRules = DataPackReaders.readRestrictionsFromDataPacks(manager);
                    if (base != null) {
                        Map dpSkillResources = manager.method_14488("skills", p -> p.method_12832().endsWith(".json"));
                        for (Map.Entry entry : dpSkillResources.entrySet()) {
                            if (!"rpglevel".equals(((class_2960)entry.getKey()).method_12836())) continue;
                            String string = ((class_2960)entry.getKey()).method_12832().substring(((class_2960)entry.getKey()).method_12832().lastIndexOf(47) + 1);
                            Path target = base.resolve("skills").resolve(string);
                            if (Files.exists(target, new LinkOption[0])) continue;
                            try {
                                InputStream in = ((class_3298)entry.getValue()).method_14482();
                                try {
                                    Files.copy(in, target, new CopyOption[0]);
                                }
                                finally {
                                    if (in == null) continue;
                                    in.close();
                                }
                            }
                            catch (Exception e) {
                                RpgLogger.error("Failed exporting default skill to config: " + String.valueOf(target), e);
                            }
                        }
                        Map dpRestrResources = manager.method_14488("restrictions", p -> p.method_12832().endsWith(".json"));
                        for (Map.Entry entry : dpRestrResources.entrySet()) {
                            if (!"rpglevel".equals(((class_2960)entry.getKey()).method_12836())) continue;
                            String fileName = ((class_2960)entry.getKey()).method_12832().substring(((class_2960)entry.getKey()).method_12832().lastIndexOf(47) + 1);
                            Path target = base.resolve("restrictions").resolve(fileName);
                            if (Files.exists(target, new LinkOption[0])) continue;
                            try {
                                InputStream in = ((class_3298)entry.getValue()).method_14482();
                                try {
                                    Files.copy(in, target, new CopyOption[0]);
                                }
                                finally {
                                    if (in == null) continue;
                                    in.close();
                                }
                            }
                            catch (Exception e) {
                                RpgLogger.error("Failed exporting default restriction to config: " + String.valueOf(target), e);
                            }
                        }
                    }
                    List<SkillDefinition> cfgSkills = base != null ? FileReaders.readSkillsFromFolder(base.resolve("skills")) : List.of();
                    List cfgRules = base != null ? FileReaders.readRestrictionsFromFolder(base.resolve("restrictions")) : List.of();
                    SkillRegistry.clearAndRegister(dpSkills);
                    if (!cfgSkills.isEmpty()) {
                        SkillRegistry.putOrReplace(cfgSkills);
                    }
                    ArrayList<RestrictionRule> combinedRules = new ArrayList<RestrictionRule>();
                    if (!cfgRules.isEmpty()) {
                        combinedRules.addAll(cfgRules);
                    }
                    if (!dpRules.isEmpty()) {
                        combinedRules.addAll(dpRules);
                    }
                    RestrictionEngine.get().clearAndAddAll(combinedRules);
                    RpgLogger.info("Configs loaded: dp(" + dpSkills.size() + "/" + dpRules.size() + ") + cfg(" + cfgSkills.size() + "/" + cfgRules.size() + ")");
                }
                catch (Exception e) {
                    RpgLogger.error("Error parsing datapack/config configs", e);
                }
            }
        };
    }

    public static void initialLoad(Path configDir) {
        RpgConfigLoader.setConfigDir(configDir);
        try {
            List<RestrictionRule> rules;
            RpgGeneralConfig.loadOrCreate(configDir);
            Path base = configDir.resolve("rpglevel");
            Files.createDirectories(base.resolve("skills"), new FileAttribute[0]);
            Files.createDirectories(base.resolve("restrictions"), new FileAttribute[0]);
            List<SkillDefinition> skills = FileReaders.readSkillsFromFolder(base.resolve("skills"));
            if (!skills.isEmpty()) {
                SkillRegistry.clearAndRegister(skills);
            }
            if (!(rules = FileReaders.readRestrictionsFromFolder(base.resolve("restrictions"))).isEmpty()) {
                RestrictionEngine.get().clearAndAddAll(rules);
            }
            RpgLogger.info("Config folder loaded: " + skills.size() + " skills, " + rules.size() + " rules.");
        }
        catch (Exception e) {
            RpgLogger.error("Error parsing config folder", e);
        }
    }

    public static void reloadAll(class_3300 manager, Path configDir) {
        RpgConfigLoader.setConfigDir(configDir);
        RpgConfigLoader.getDatapackReloadListener().method_14491(manager);
    }

    private static SkillDefinition parseSkill(Reader r) {
        JsonObject obj = (JsonObject)GSON.fromJson(r, JsonObject.class);
        class_2960 id = new class_2960(obj.get("id").getAsString());
        int maxLevel = obj.get("maxLevel").getAsInt();
        TreeMap<Integer, Long> curve = new TreeMap<Integer, Long>();
        JsonObject xp = obj.getAsJsonObject("xpCurve");
        for (Map.Entry e : xp.entrySet()) {
            curve.put(Integer.parseInt((String)e.getKey()), ((JsonElement)e.getValue()).getAsLong());
        }
        HashMap<String, Double> attrs = new HashMap<String, Double>();
        if (obj.has("attributes")) {
            JsonObject at = obj.getAsJsonObject("attributes");
            for (Map.Entry e : at.entrySet()) {
                attrs.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsDouble());
            }
        }
        String description = obj.has("description") ? obj.get("description").getAsString() : null;
        String howTo = obj.has("howTo") ? obj.get("howTo").getAsString() : null;
        return new SkillDefinition(id, maxLevel, curve, attrs, description, howTo);
    }

    private static List<RestrictionRule> parseRestrictionFile(Reader r) {
        JsonElement root = JsonParser.parseReader((Reader)r);
        ArrayList<RestrictionRule> out = new ArrayList<RestrictionRule>();
        if (root.isJsonArray()) {
            for (JsonElement el : root.getAsJsonArray()) {
                out.add(RpgConfigLoader.parseRule(el.getAsJsonObject()));
            }
        } else {
            out.add(RpgConfigLoader.parseRule(root.getAsJsonObject()));
        }
        return out;
    }

    private static RestrictionRule parseRule(JsonObject obj) {
        RestrictionRule.Action action = RestrictionRule.Action.valueOf(obj.get("action").getAsString().toUpperCase(Locale.ROOT));
        Set<class_2960> itemIds = RpgConfigLoader.setOfIdentifiers(obj, "itemIds");
        Set<class_2960> itemTags = RpgConfigLoader.setOfIdentifiers(obj, "itemTags");
        Set<class_2960> blockIds = RpgConfigLoader.setOfIdentifiers(obj, "blockIds");
        Set<class_2960> blockTags = RpgConfigLoader.setOfIdentifiers(obj, "blockTags");
        HashMap<class_2960, Integer> req = new HashMap<class_2960, Integer>();
        if (obj.has("requirements")) {
            JsonObject r = obj.getAsJsonObject("requirements");
            for (Map.Entry e : r.entrySet()) {
                req.put(new class_2960((String)e.getKey()), ((JsonElement)e.getValue()).getAsInt());
            }
        }
        String message = obj.has("message") ? obj.get("message").getAsString() : null;
        return new RestrictionRule(action, itemIds, itemTags, blockIds, blockTags, req, message);
    }

    private static Set<class_2960> setOfIdentifiers(JsonObject obj, String key) {
        if (!obj.has(key)) {
            return Set.of();
        }
        HashSet<class_2960> out = new HashSet<class_2960>();
        for (JsonElement el : obj.getAsJsonArray(key)) {
            out.add(new class_2960(el.getAsString()));
        }
        return out;
    }

    static final class FileReaders {
        FileReaders() {
        }

        static List<SkillDefinition> readSkillsFromFolder(Path folder) throws IOException {
            if (!Files.exists(folder, new LinkOption[0])) {
                return List.of();
            }
            ArrayList<SkillDefinition> out = new ArrayList<SkillDefinition>();
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(folder, "*.json");){
                for (Path p : ds) {
                    BufferedReader br = Files.newBufferedReader(p);
                    try {
                        out.add(RpgConfigLoader.parseSkill(br));
                    }
                    finally {
                        if (br == null) continue;
                        br.close();
                    }
                }
            }
            return out;
        }

        static List<RestrictionRule> readRestrictionsFromFolder(Path folder) throws IOException {
            if (!Files.exists(folder, new LinkOption[0])) {
                return List.of();
            }
            ArrayList<RestrictionRule> out = new ArrayList<RestrictionRule>();
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(folder, "*.json");){
                for (Path p : ds) {
                    BufferedReader br = Files.newBufferedReader(p);
                    try {
                        out.addAll(RpgConfigLoader.parseRestrictionFile(br));
                    }
                    finally {
                        if (br == null) continue;
                        br.close();
                    }
                }
            }
            return out;
        }
    }

    static final class DataPackReaders {
        DataPackReaders() {
        }

        static List<SkillDefinition> readSkillsFromDataPacks(class_3300 manager) {
            ArrayList<SkillDefinition> out = new ArrayList<SkillDefinition>();
            Map resources = manager.method_14488("skills", path -> path.method_12832().endsWith(".json"));
            for (Map.Entry entry : resources.entrySet()) {
                try {
                    BufferedReader r = ((class_3298)entry.getValue()).method_43039();
                    try {
                        out.add(RpgConfigLoader.parseSkill(r));
                    }
                    finally {
                        if (r == null) continue;
                        ((Reader)r).close();
                    }
                }
                catch (Exception e) {
                    RpgLogger.error("Failed to parse skill file: " + String.valueOf(entry.getKey()), e);
                }
            }
            return out;
        }

        static List<RestrictionRule> readRestrictionsFromDataPacks(class_3300 manager) {
            ArrayList<RestrictionRule> out = new ArrayList<RestrictionRule>();
            Map resources = manager.method_14488("restrictions", path -> path.method_12832().endsWith(".json"));
            for (Map.Entry entry : resources.entrySet()) {
                try {
                    BufferedReader r = ((class_3298)entry.getValue()).method_43039();
                    try {
                        out.addAll(RpgConfigLoader.parseRestrictionFile(r));
                    }
                    finally {
                        if (r == null) continue;
                        ((Reader)r).close();
                    }
                }
                catch (Exception e) {
                    RpgLogger.error("Failed to parse restriction file: " + String.valueOf(entry.getKey()), e);
                }
            }
            return out;
        }
    }
}

