/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1671;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.g_skyrim.rpglevel.Rpglevel;
import org.g_skyrim.rpglevel.config.RpgGeneralConfig;
import org.g_skyrim.rpglevel.player.PlayerSkills;
import org.g_skyrim.rpglevel.skills.SkillRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityDamageMixin {
    @Unique
    private float rpglevel$preDamageHealth;

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void rpglevel$capturePreDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 self = (class_1309)this;
        this.rpglevel$preDamageHealth = self.method_6032();
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    private void rpglevel$onDamaged(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 victim = (class_1309)this;
        if (victim.method_37908().method_8608()) {
            return;
        }
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        float post = victim.method_6032();
        float delta = Math.max(0.0f, this.rpglevel$preDamageHealth - post);
        if (delta <= 0.0f) {
            return;
        }
        class_1297 srcAttacker = source.method_5529();
        class_1297 direct = source.method_5526();
        class_3222 archeryPlayer = this.rpglevel$findArcheryPlayer(direct);
        long xp = Math.max(1L, (long)Math.round(delta));
        if (archeryPlayer != null) {
            Rpglevel.awardXp(archeryPlayer, new class_2960("rpglevel", "archery"), xp);
            this.rpglevel$applyDamageBonus(archeryPlayer, new class_2960("rpglevel", "archery"), RpgGeneralConfig.get().benefits.archeryDamageBonusMax, victim, post, delta);
        } else if (srcAttacker instanceof class_3222) {
            class_3222 playerAttacker = (class_3222)srcAttacker;
            Rpglevel.awardXp(playerAttacker, new class_2960("rpglevel", "combat"), xp);
            this.rpglevel$applyDamageBonus(playerAttacker, new class_2960("rpglevel", "combat"), RpgGeneralConfig.get().benefits.combatDamageBonusMax, victim, post, delta);
        }
        if (victim instanceof class_3222) {
            float healBack;
            int maxLvlD;
            double perLvlD;
            int dLvl;
            double maxD;
            double reduce;
            class_3222 playerVictim = (class_3222)victim;
            if (srcAttacker instanceof class_1309 && !(srcAttacker instanceof class_1657)) {
                long xpDef = Math.max(1L, (long)Math.round(delta));
                Rpglevel.awardXp(playerVictim, new class_2960("rpglevel", "defense"), xpDef);
            }
            if ((reduce = Math.min(maxD = RpgGeneralConfig.get().benefits.defenseMitigationMax, (double)(dLvl = PlayerSkills.of(playerVictim.method_5667()).getLevel(new class_2960("rpglevel", "defense"))) * (perLvlD = (maxLvlD = SkillRegistry.get(new class_2960("rpglevel", "defense")).map(def -> def.maxLevel()).orElse(50).intValue()) > 0 ? maxD / (double)maxLvlD : 0.0))) > 0.0 && (healBack = (float)((double)delta * reduce)) > 0.0f) {
                victim.method_6033(Math.min(victim.method_6063(), post + healBack));
            }
        }
    }

    @Unique
    private class_3222 rpglevel$findArcheryPlayer(class_1297 direct) {
        class_1671 firework;
        class_1667 arrow;
        class_1297 owner;
        if (direct instanceof class_1667 && (owner = (arrow = (class_1667)direct).method_24921()) instanceof class_3222) {
            class_3222 sp = (class_3222)owner;
            return sp;
        }
        if (direct instanceof class_1671 && (owner = (firework = (class_1671)direct).method_24921()) instanceof class_3222) {
            class_3222 sp = (class_3222)owner;
            return sp;
        }
        return null;
    }

    @Unique
    private void rpglevel$applyDamageBonus(class_3222 player, class_2960 skillId, double maxBenefit, class_1309 victim, float post, float delta) {
        float extra;
        int maxLvl;
        double perLvl;
        if (player == null || victim == null || delta <= 0.0f) {
            return;
        }
        int lvl = PlayerSkills.of(player.method_5667()).getLevel(skillId);
        double bonus = Math.min(maxBenefit, (double)lvl * (perLvl = (maxLvl = SkillRegistry.get(skillId).map(def -> def.maxLevel()).orElse(50).intValue()) > 0 ? maxBenefit / (double)maxLvl : 0.0));
        if (bonus > 0.0 && (extra = (float)((double)delta * bonus)) > 0.0f && !victim.method_29504()) {
            victim.method_6033(Math.max(0.0f, post - extra));
        }
    }
}

