/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.skills;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import org.g_skyrim.rpglevel.skills.SkillDefinition;
import org.g_skyrim.rpglevel.util.RpgLogger;

public final class SkillRegistry {
    private static final Map<class_2960, SkillDefinition> SKILLS = new ConcurrentHashMap<class_2960, SkillDefinition>();

    private SkillRegistry() {
    }

    public static void bootstrap() {
        RpgLogger.info("SkillRegistry ready (awaiting config load).");
    }

    public static void clearAndRegister(Collection<SkillDefinition> defs) {
        SKILLS.clear();
        for (SkillDefinition def : defs) {
            SKILLS.put(def.id(), def);
        }
        RpgLogger.info("Registered " + SKILLS.size() + " skills.");
    }

    public static void putOrReplace(Collection<SkillDefinition> defs) {
        for (SkillDefinition def : defs) {
            SKILLS.put(def.id(), def);
        }
        RpgLogger.info("Updated " + defs.size() + " skills (total now " + SKILLS.size() + ").");
    }

    public static Optional<SkillDefinition> get(class_2960 id) {
        return Optional.ofNullable(SKILLS.get(id));
    }

    public static List<class_2960> allIdsSnapshot() {
        return new ArrayList<class_2960>(SKILLS.keySet());
    }
}

