/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.g_skyrim.rpglevel.Rpglevel;
import org.g_skyrim.rpglevel.config.RpgConfigLoader;
import org.g_skyrim.rpglevel.network.RpgNetwork;
import org.g_skyrim.rpglevel.player.PlayerSkills;
import org.g_skyrim.rpglevel.skills.SkillRegistry;

public final class RpgCommands {
    private RpgCommands() {
    }

    private static class_2960 normalizeSkillId(class_2960 input) {
        if (SkillRegistry.get(input).isPresent()) {
            return input;
        }
        class_2960 alt = new class_2960("rpglevel", input.method_12832());
        if (SkillRegistry.get(alt).isPresent()) {
            return alt;
        }
        return input;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rpglevel").then(class_2170.method_9247((String)"get").then(class_2170.method_9247((String)"stats").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 player = src.method_9207();
            PlayerSkills ps = PlayerSkills.of(player.method_5667());
            List<class_2960> ids = SkillRegistry.allIdsSnapshot();
            ids.sort(Comparator.comparing(class_2960::toString));
            if (ids.isEmpty()) {
                src.method_9226(() -> class_2561.method_43470((String)"No skills registered."), false);
                return 1;
            }
            StringBuilder sb = new StringBuilder(64 + ids.size() * 24);
            sb.append("RPG Stats:\n");
            for (class_2960 id : ids) {
                int lvl = ps.getLevel(id);
                long xp = ps.getXp(id);
                sb.append("- ").append(id).append(": lvl ").append(lvl).append(", xp ").append(xp).append('\n');
            }
            src.method_9226(() -> class_2561.method_43470((String)sb.toString()), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"skill", (ArgumentType)class_2232.method_9441()).suggests((ctx, builder) -> class_2172.method_9264(SkillRegistry.allIdsSnapshot().stream().map(class_2960::method_12832).distinct(), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 player = src.method_9207();
            class_2960 raw = class_2232.method_9443((CommandContext)ctx, (String)"skill");
            class_2960 skill = RpgCommands.normalizeSkillId(raw);
            int lvl = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level");
            if (SkillRegistry.get(skill).isEmpty()) {
                src.method_9226(() -> class_2561.method_43470((String)("Unknown skill: " + String.valueOf(raw))), false);
                return 0;
            }
            int before = PlayerSkills.of(player.method_5667()).getLevel(skill);
            PlayerSkills.of(player.method_5667()).setLevel(skill, lvl);
            int after = PlayerSkills.of(player.method_5667()).getLevel(skill);
            Rpglevel.handleLevelChange(player, skill, before, after);
            RpgNetwork.sendSnapshot(player);
            src.method_9226(() -> class_2561.method_43470((String)("Set " + String.valueOf(skill) + " to " + lvl)), false);
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"addxp").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"skill", (ArgumentType)class_2232.method_9441()).then(class_2170.method_9244((String)"xp", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 player = src.method_9207();
            class_2960 raw = class_2232.method_9443((CommandContext)ctx, (String)"skill");
            class_2960 skill = RpgCommands.normalizeSkillId(raw);
            int xp = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"xp");
            if (SkillRegistry.get(skill).isEmpty()) {
                src.method_9226(() -> class_2561.method_43470((String)("Unknown skill: " + String.valueOf(raw))), false);
                return 0;
            }
            Rpglevel.awardXp(player, skill, xp);
            RpgNetwork.sendSnapshot(player);
            src.method_9226(() -> class_2561.method_43470((String)("Added " + xp + " XP to " + String.valueOf(skill))), false);
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(src -> src.method_9259(2))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            MinecraftServer server = src.method_9211();
            RpgConfigLoader.reloadAll(server.method_34864(), FabricLoader.getInstance().getConfigDir());
            src.method_9226(() -> class_2561.method_43470((String)"RPG configs reloaded."), false);
            return 1;
        }))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            List<class_2960> ids = SkillRegistry.allIdsSnapshot();
            ids.sort(Comparator.comparing(class_2960::toString));
            if (ids.isEmpty()) {
                src.method_9226(() -> class_2561.method_43470((String)"No skills registered."), false);
                return 1;
            }
            StringBuilder sb = new StringBuilder("Skills (" + ids.size() + "):\n");
            for (class_2960 id : ids) {
                sb.append("- ").append(id).append('\n');
            }
            src.method_9226(() -> class_2561.method_43470((String)sb.toString()), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(src -> src.method_9259(2))).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 player = src.method_9207();
            PlayerSkills.of(player.method_5667()).resetAll();
            RpgNetwork.sendSnapshot(player);
            src.method_9226(() -> class_2561.method_43470((String)"Your RPG skills have been reset."), false);
            return 1;
        }));
        dispatcher.register(root);
    }
}

