/*
 * Decompiled with CFR 0.152.
 */
package net.huwng.holospark.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.huwng.holospark.init.HolosparkModBlockEntities;
import net.huwng.holospark.init.HolosparkModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class HoloCoreBlockEntity
extends BlockEntity {
    public static final int DEFAULT_RADIUS = 24;
    public static final int DEFAULT_RENDER_GRID = 3;
    private int upgradeRadius = 24;
    private int scanDurationTicks = 60;
    private boolean poweredScanned = false;
    private long scanStart = 0L;
    private int worldRadius = 24;
    private int renderGrid = 3;
    private static final int DEFAULT_SCAN_SECONDS = 3;
    private int[][] heightmap = new int[48][48];
    private int[][] seaLevelMap = new int[48][48];
    private final List<ScannedEntity> scannedEntities = new ArrayList<ScannedEntity>();

    public HoloCoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HolosparkModBlockEntities.HOLO_CORE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HoloCoreBlockEntity be) {
        boolean powered;
        if (be.isPoweredScanned()) {
            be.scanEntities(level, pos);
        }
        if (powered = level.m_276867_(pos)) {
            if (!be.poweredScanned) {
                be.poweredScanned = true;
                be.scanStart = level.m_46467_();
                be.scanDurationTicks = 60;
                be.buildHeightmap(level, pos);
                be.m_6596_();
                level.m_7260_(pos, state, state, 3);
                if (HolosparkModSounds.SCAN.get() != null) {
                    level.m_5594_(null, pos, (SoundEvent)HolosparkModSounds.SCAN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    level.m_5594_(null, pos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            be.scanEntities(level, pos);
        } else if (be.poweredScanned) {
            be.poweredScanned = false;
            be.scannedEntities.clear();
            be.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void buildHeightmap(Level level, BlockPos pos) {
        int radius = this.worldRadius;
        if (this.heightmap.length != 2 * radius || this.heightmap[0].length != 2 * radius) {
            this.heightmap = new int[2 * radius][2 * radius];
        }
        for (int dx = 0; dx < 2 * radius; ++dx) {
            for (int dz = 0; dz < 2 * radius; ++dz) {
                int x = pos.m_123341_() + dx - radius;
                int z = pos.m_123343_() + dz - radius;
                if (!level.m_46749_(new BlockPos(x, level.m_5736_(), z))) {
                    this.heightmap[dx][dz] = level.m_5736_();
                    continue;
                }
                int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                BlockPos topPos = new BlockPos(x, Math.max(level.m_141937_(), y - 1), z);
                BlockState state = level.m_8055_(topPos);
                while (y > level.m_141937_() && state.m_60819_().m_76170_()) {
                    --y;
                    topPos = topPos.m_7495_();
                    state = level.m_8055_(topPos);
                }
                if (y <= level.m_141937_()) {
                    y = level.m_5736_();
                }
                this.heightmap[dx][dz] = y;
            }
        }
    }

    private void scanEntities(Level level, BlockPos pos) {
        this.scannedEntities.clear();
        int r = this.worldRadius;
        AABB box = new AABB(pos).m_82400_((double)r);
        for (Entity e : level.m_45933_(null, box)) {
            int color;
            if (e == null) continue;
            if (e instanceof Player) {
                color = 65280;
            } else if (e.m_6095_().m_20674_() == MobCategory.MONSTER) {
                color = 0xFF0000;
            } else if (e instanceof LivingEntity) {
                color = 0xFFFF00;
            } else {
                if (!(e instanceof ItemEntity)) continue;
                color = 0xFFFFFF;
            }
            int mapX = (int)Math.floor(e.m_20185_()) - pos.m_123341_() + r;
            int mapZ = (int)Math.floor(e.m_20189_()) - pos.m_123343_() + r;
            if (mapX >= 0 && mapX < 2 * r && mapZ >= 0 && mapZ < 2 * r) {
                int groundY = this.heightmap[mapX][mapZ];
                if (e.m_20186_() < (double)(groundY - 2) && !e.m_20069_()) continue;
            }
            float width = e.m_20205_();
            float height = e.m_20206_();
            this.scannedEntities.add(new ScannedEntity(e.m_20185_(), e.m_20186_(), e.m_20189_(), color, width, height));
        }
    }

    public void togglePower(Level level, BlockPos pos, BlockState state) {
        if (level.f_46443_) {
            return;
        }
        boolean bl = this.poweredScanned = !this.poweredScanned;
        if (this.poweredScanned) {
            this.scanStart = level.m_46467_();
            this.buildHeightmap(level, pos);
            if (HolosparkModSounds.SCAN.get() != null) {
                level.m_5594_(null, pos, (SoundEvent)HolosparkModSounds.SCAN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            this.scannedEntities.clear();
        }
        this.m_6596_();
        level.m_7260_(pos, state, state, 3);
    }

    public boolean applyUpgrade(Level level, BlockPos pos, BlockState state, String upgrade) {
        if (level.f_46443_) {
            return false;
        }
        if ("basic".equals(upgrade)) {
            this.worldRadius = 40;
            this.renderGrid = 5;
            this.scanDurationTicks = 80;
        } else if ("advanced".equals(upgrade)) {
            this.worldRadius = 56;
            this.renderGrid = 7;
            this.scanDurationTicks = 120;
        } else if ("elite".equals(upgrade)) {
            this.worldRadius = 72;
            this.renderGrid = 9;
            this.scanDurationTicks = 140;
        } else if ("super".equals(upgrade)) {
            this.worldRadius = 88;
            this.renderGrid = 11;
            this.scanDurationTicks = 160;
        } else if ("ultimate".equals(upgrade)) {
            this.worldRadius = 104;
            this.renderGrid = 13;
            this.scanDurationTicks = 160;
        } else if ("absolute".equals(upgrade)) {
            this.worldRadius = 136;
            this.renderGrid = 17;
            this.scanDurationTicks = 200;
        } else {
            return false;
        }
        this.buildHeightmap(level, pos);
        this.scanStart = level.m_46467_();
        this.poweredScanned = true;
        this.m_6596_();
        level.m_7260_(pos, state, state, 3);
        if (HolosparkModSounds.SCAN.get() != null) {
            level.m_5594_(null, pos, (SoundEvent)HolosparkModSounds.SCAN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public boolean isPoweredScanned() {
        return this.poweredScanned;
    }

    public long getScanStart() {
        return this.scanStart;
    }

    public int getScanDurationTicks() {
        return this.scanDurationTicks;
    }

    public int getWorldRadius() {
        return this.worldRadius;
    }

    public int getRenderGrid() {
        return this.renderGrid;
    }

    public int[][] getHeightmap() {
        return this.heightmap;
    }

    public List<ScannedEntity> getScannedEntities() {
        return this.scannedEntities;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("PoweredScanned", this.poweredScanned);
        tag.m_128356_("ScanStart", this.scanStart);
        tag.m_128405_("WorldRadius", this.worldRadius);
        tag.m_128405_("RenderGrid", this.renderGrid);
        tag.m_128405_("ScanDurationTicks", this.scanDurationTicks);
        int r = this.worldRadius;
        int[] flat = new int[2 * r * 2 * r];
        int idx = 0;
        for (int i = 0; i < 2 * r; ++i) {
            for (int j = 0; j < 2 * r; ++j) {
                flat[idx++] = i < this.heightmap.length && j < this.heightmap[0].length ? this.heightmap[i][j] : 0;
            }
        }
        tag.m_128385_("Heightmap", flat);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.poweredScanned = tag.m_128471_("PoweredScanned");
        this.scanStart = tag.m_128454_("ScanStart");
        this.worldRadius = tag.m_128441_("WorldRadius") ? tag.m_128451_("WorldRadius") : 24;
        this.renderGrid = tag.m_128441_("RenderGrid") ? tag.m_128451_("RenderGrid") : 3;
        int n = this.scanDurationTicks = tag.m_128441_("ScanDurationTicks") ? tag.m_128451_("ScanDurationTicks") : 60;
        if (tag.m_128441_("Heightmap")) {
            int r = this.worldRadius;
            int[] flat = tag.m_128465_("Heightmap");
            this.heightmap = new int[2 * r][2 * r];
            int idx = 0;
            for (int i = 0; i < 2 * r; ++i) {
                for (int j = 0; j < 2 * r; ++j) {
                    this.heightmap[i][j] = idx < flat.length ? flat[idx++] : 0;
                }
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public record ScannedEntity(double x, double y, double z, int color, float width, float height) {
    }
}

