/*
 * Decompiled with CFR 0.152.
 */
package net.huwng.holospark.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.huwng.holospark.block.entity.HoloCoreBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class HoloCoreRenderer
implements BlockEntityRenderer<HoloCoreBlockEntity> {
    private static final ResourceLocation HOLOGRAM_TEX = new ResourceLocation("holospark", "textures/hologram.png");

    public HoloCoreRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(HoloCoreBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (!be.isPoweredScanned()) {
            return;
        }
        int[][] map = be.getHeightmap();
        int radius = be.getWorldRadius();
        int grid = be.getRenderGrid();
        int worldSize = 2 * radius;
        if (map == null || map.length < worldSize) {
            return;
        }
        long gameTime = be.m_58904_() != null ? be.m_58904_().m_46467_() : 0L;
        long elapsed = gameTime - be.getScanStart();
        float progress = Math.min(1.0f, ((float)elapsed + partialTicks) / (float)be.getScanDurationTicks());
        int rowsToReveal = Math.max(1, (int)Math.floor((float)worldSize * progress));
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.0, 0.5);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)HOLOGRAM_TEX));
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int i = 0; i < worldSize; ++i) {
            for (int j = 0; j < worldSize; ++j) {
                int y = map[i][j];
                if (y <= 0) continue;
                if (y < minY) {
                    minY = y;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        if (minY == Integer.MAX_VALUE) {
            poseStack.m_85849_();
            return;
        }
        float renderSize = grid;
        float scale = renderSize / (float)worldSize;
        int heightRange = maxY - minY;
        float effectiveHeight = heightRange <= 5 ? (float)heightRange : 5.0f;
        for (int j = 0; j < rowsToReveal; ++j) {
            for (int i = 0; i < worldSize; ++i) {
                boolean isEdge;
                int y = map[i][j];
                if (y <= 0) continue;
                float hy = heightRange > 0 ? (float)(y - minY) * (effectiveHeight / (float)heightRange) : 0.0f;
                float normH = heightRange > 0 ? (float)(y - minY) / (float)heightRange : 0.0f;
                float hx = ((float)i - (float)worldSize / 2.0f) * scale + scale * 0.5f;
                float hz = ((float)j - (float)worldSize / 2.0f) * scale + scale * 0.5f;
                float dist = (float)Math.sqrt(Math.pow((float)i - (float)worldSize / 2.0f, 2.0) + Math.pow((float)j - (float)worldSize / 2.0f, 2.0)) / ((float)worldSize / 2.0f);
                if (dist > 1.0f) {
                    dist = 1.0f;
                }
                boolean baseR = false;
                int baseG = (int)(150.0f + normH * 105.0f);
                int baseB = 255;
                int r = (int)((float)baseR * (1.0f - dist) + 255.0f * dist);
                int g = (int)((float)baseG * (1.0f - dist) + 255.0f * dist);
                int b = (int)((float)baseB * (1.0f - dist) + 255.0f * dist);
                int a = 180;
                float nHy = j > 0 ? (float)(map[i][j - 1] - minY) * (effectiveHeight / (float)heightRange) : 0.0f;
                float sHy = j < worldSize - 1 ? (float)(map[i][j + 1] - minY) * (effectiveHeight / (float)heightRange) : 0.0f;
                float wHy = i > 0 ? (float)(map[i - 1][j] - minY) * (effectiveHeight / (float)heightRange) : 0.0f;
                float eHy = i < worldSize - 1 ? (float)(map[i + 1][j] - minY) * (effectiveHeight / (float)heightRange) : 0.0f;
                this.drawTop(builder, poseStack, hx, hy, hz, scale, r, g, b, a, overlay);
                boolean bl = isEdge = i == 0 || j == 0 || i == worldSize - 1 || j == worldSize - 1;
                if (!isEdge && hy > nHy + 0.01f) {
                    this.drawSide(builder, poseStack, hx, nHy, hz, scale, hy - nHy, r, g, b, a, overlay, "N");
                }
                if (!isEdge && hy > sHy + 0.01f) {
                    this.drawSide(builder, poseStack, hx, sHy, hz, scale, hy - sHy, r, g, b, a, overlay, "S");
                }
                if (!isEdge && hy > wHy + 0.01f) {
                    this.drawSide(builder, poseStack, hx, wHy, hz, scale, hy - wHy, r, g, b, a, overlay, "W");
                }
                if (isEdge || !(hy > eHy + 0.01f)) continue;
                this.drawSide(builder, poseStack, hx, eHy, hz, scale, hy - eHy, r, g, b, a, overlay, "E");
            }
        }
        int sea = be.m_58904_().m_5736_();
        float seaHeight = (float)(sea - minY) * (effectiveHeight / (float)heightRange);
        for (int i = 0; i < worldSize; ++i) {
            for (int j = 0; j < worldSize; ++j) {
                float hx = ((float)i - (float)worldSize / 2.0f) * scale + scale * 0.5f;
                float hz = ((float)j - (float)worldSize / 2.0f) * scale + scale * 0.5f;
                int r = 0;
                int g = 100;
                int b = 255;
                int a = 100;
                this.drawTop(builder, poseStack, hx, seaHeight, hz, scale, r, g, b, a, overlay);
            }
        }
        for (Entity e : be.m_58904_().m_45933_(null, new AABB(be.m_58899_()).m_82400_((double)radius))) {
            int color;
            if (e instanceof Player) {
                color = 65280;
            } else if (e.m_6095_().m_20674_() == MobCategory.MONSTER) {
                color = 0xFF0000;
            } else if (e instanceof LivingEntity) {
                color = 0xFFFF00;
            } else {
                if (!(e instanceof ItemEntity)) continue;
                color = 0xFFFFFF;
            }
            double exWorld = e.f_19790_ + (e.m_20185_() - e.f_19790_) * (double)partialTicks;
            double eyWorld = e.f_19791_ + (e.m_20186_() - e.f_19791_) * (double)partialTicks;
            double ezWorld = e.f_19792_ + (e.m_20189_() - e.f_19792_) * (double)partialTicks;
            double baseX = be.m_58899_().m_123341_() - radius;
            double baseZ = be.m_58899_().m_123343_() - radius;
            double relX = exWorld - baseX;
            double relZ = ezWorld - baseZ;
            float ex = (float)(relX / (double)worldSize * (double)renderSize - (double)renderSize / 2.0);
            float ez = (float)(relZ / (double)worldSize * (double)renderSize - (double)renderSize / 2.0);
            float ey = maxY > minY ? (float)((eyWorld - (double)minY) / (double)(maxY - minY)) * 5.0f : 0.6f;
            float cubeX = Math.max(0.05f, e.m_20205_() / (float)worldSize * renderSize);
            float cubeY = Math.max(0.05f, e.m_20206_() / (float)(maxY - minY) * 5.0f);
            float cubeZ = cubeX;
            int rr = color >> 16 & 0xFF;
            int gg = color >> 8 & 0xFF;
            int bb = color & 0xFF;
            this.drawEntityCube(builder, poseStack, ex, ey, ez, cubeX, cubeY, cubeZ, rr, gg, bb, 220, overlay);
        }
        poseStack.m_85849_();
    }

    private void drawTop(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float size, int r, int g, int b, int a, int overlay) {
        float half = size * 0.5f;
        PoseStack.Pose pose = poseStack.m_85850_();
        int fullbright = 0xF000F0;
        builder.m_252986_(pose.m_252922_(), x - half, y, z - half).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), x + half, y, z - half).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), x + half, y, z + half).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), x - half, y, z + half).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void drawSide(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float size, float height, int r, int g, int b, int a, int overlay, String dir) {
        float half = size * 0.5f;
        PoseStack.Pose pose = poseStack.m_85850_();
        int fullbright = 0xF000F0;
        switch (dir) {
            case "N": {
                builder.m_252986_(pose.m_252922_(), x - half, y, z - half).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x + half, y, z - half).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x + half, y + height, z - half).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x - half, y + height, z - half).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
                break;
            }
            case "S": {
                builder.m_252986_(pose.m_252922_(), x - half, y, z + half).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x + half, y, z + half).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x + half, y + height, z + half).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x - half, y + height, z + half).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
                break;
            }
            case "E": {
                builder.m_252986_(pose.m_252922_(), x + half, y, z - half).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x + half, y, z + half).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x + half, y + height, z + half).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x + half, y + height, z - half).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
                break;
            }
            case "W": {
                builder.m_252986_(pose.m_252922_(), x - half, y, z - half).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x - half, y, z + half).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x - half, y + height, z + half).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pose.m_252922_(), x - half, y + height, z - half).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
            }
        }
    }

    private void drawEntityDot(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float size, int r, int g, int b, int a, int overlay) {
        float half = size * 0.5f;
        PoseStack.Pose pose = poseStack.m_85850_();
        int fullbright = 0xF000F0;
        builder.m_252986_(pose.m_252922_(), x - half, y, z - half).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), x + half, y, z - half).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), x + half, y, z + half).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), x - half, y, z + half).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void drawEntityCube(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float sx, float sy, float sz, int r, int g, int b, int a, int overlay) {
        PoseStack.Pose pose = poseStack.m_85850_();
        int fullbright = 0xF000F0;
        float minX = x - sx / 2.0f;
        float maxX = x + sx / 2.0f;
        float minY = y;
        float maxY = y + sy;
        float minZ = z - sz / 2.0f;
        float maxZ = z + sz / 2.0f;
        builder.m_252986_(pose.m_252922_(), minX, maxY, minZ).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, maxY, minZ).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, maxY, maxZ).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, maxY, maxZ).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, minY, minZ).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, minY, minZ).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, minY, maxZ).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, minY, maxZ).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, minY, minZ).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, minY, minZ).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, maxY, minZ).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, maxY, minZ).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, minY, maxZ).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, minY, maxZ).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, maxY, maxZ).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, maxY, maxZ).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, minY, minZ).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, minY, maxZ).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, maxY, maxZ).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), maxX, maxY, minZ).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, minY, minZ).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, minY, maxZ).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, maxY, maxZ).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), minX, maxY, minZ).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(fullbright).m_252939_(pose.m_252943_(), -1.0f, 0.0f, 0.0f).m_5752_();
    }

    public boolean shouldRenderOffScreen(HoloCoreBlockEntity be) {
        return true;
    }
}

