/*
 * Decompiled with CFR 0.152.
 */
package copper.technologies.pc.network;

import copper.technologies.pc.CoptechMod;
import copper.technologies.pc.procedures.BankomatGPDBalanceDown16Procedure;
import copper.technologies.pc.procedures.BankomatGPDBalanceDown32Procedure;
import copper.technologies.pc.procedures.BankomatGPDBalanceDown48Procedure;
import copper.technologies.pc.procedures.BankomatGPDBalanceDown64Procedure;
import copper.technologies.pc.procedures.BankomatGPDtoBackProcedure;
import copper.technologies.pc.world.inventory.BankomatGPDGuiBalanceDownMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BankomatGPDGuiBalanceDownButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public BankomatGPDGuiBalanceDownButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public BankomatGPDGuiBalanceDownButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(BankomatGPDGuiBalanceDownButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(BankomatGPDGuiBalanceDownButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            BankomatGPDGuiBalanceDownButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = BankomatGPDGuiBalanceDownMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BankomatGPDtoBackProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            BankomatGPDBalanceDown16Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            BankomatGPDBalanceDown32Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            BankomatGPDBalanceDown48Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            BankomatGPDBalanceDown64Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoptechMod.addNetworkMessage(BankomatGPDGuiBalanceDownButtonMessage.class, BankomatGPDGuiBalanceDownButtonMessage::buffer, BankomatGPDGuiBalanceDownButtonMessage::new, BankomatGPDGuiBalanceDownButtonMessage::handler);
    }
}

