/*
 * Decompiled with CFR 0.152.
 */
package copper.technologies.pc.network;

import copper.technologies.pc.CoptechMod;
import copper.technologies.pc.procedures.CustomPhoneButtonInformationProcedure;
import copper.technologies.pc.procedures.CustomPhoneButtonMessagerProcedure;
import copper.technologies.pc.procedures.CustomPhoneButtonOptionsProcedure;
import copper.technologies.pc.procedures.CustomPhoneButtonSMSProcedure;
import copper.technologies.pc.procedures.CustomPhoneProcedureHomeProcedure;
import copper.technologies.pc.world.inventory.CustomPhoneMenuMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CustomPhoneMenuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CustomPhoneMenuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CustomPhoneMenuButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CustomPhoneMenuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CustomPhoneMenuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            CustomPhoneMenuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = CustomPhoneMenuMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CustomPhoneProcedureHomeProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            CustomPhoneButtonMessagerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            CustomPhoneButtonOptionsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            CustomPhoneButtonInformationProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            CustomPhoneButtonSMSProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoptechMod.addNetworkMessage(CustomPhoneMenuButtonMessage.class, CustomPhoneMenuButtonMessage::buffer, CustomPhoneMenuButtonMessage::new, CustomPhoneMenuButtonMessage::handler);
    }
}

