/*
 * Decompiled with CFR 0.152.
 */
package copper.technologies.pc.network;

import copper.technologies.pc.CoptechMod;
import copper.technologies.pc.procedures.CellDiamondProcedure;
import copper.technologies.pc.procedures.CellGoldProcedure;
import copper.technologies.pc.procedures.CellLapisProcedure;
import copper.technologies.pc.procedures.CellNetheriteProcedure;
import copper.technologies.pc.procedures.CellStarProcedure;
import copper.technologies.pc.procedures.CellcopperProcedure;
import copper.technologies.pc.procedures.CellironProcedure;
import copper.technologies.pc.procedures.MetallBankOpenServicesProcedure;
import copper.technologies.pc.procedures.MetallbankrazmenProcedure;
import copper.technologies.pc.procedures.SearchProcedure;
import copper.technologies.pc.world.inventory.MetallbankMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MetallbankButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MetallbankButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MetallbankButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MetallbankButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MetallbankButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MetallbankButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = MetallbankMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SearchProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 1) {
            CellLapisProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            CellironProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            CellcopperProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            CellGoldProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            CellDiamondProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            CellStarProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            CellNetheriteProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            MetallbankrazmenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            MetallBankOpenServicesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoptechMod.addNetworkMessage(MetallbankButtonMessage.class, MetallbankButtonMessage::buffer, MetallbankButtonMessage::new, MetallbankButtonMessage::handler);
    }
}

