/*
 * Decompiled with CFR 0.152.
 */
package copper.technologies.pc.network;

import copper.technologies.pc.CoptechMod;
import copper.technologies.pc.procedures.PowerStabilizerSlotChangeProcedure;
import copper.technologies.pc.world.inventory.PowerStabilizerGUIMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PowerStabilizerGUISlotMessage {
    private final int slotID;
    private final int x;
    private final int y;
    private final int z;
    private final int changeType;
    private final int meta;

    public PowerStabilizerGUISlotMessage(int slotID, int x, int y, int z, int changeType, int meta) {
        this.slotID = slotID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.changeType = changeType;
        this.meta = meta;
    }

    public PowerStabilizerGUISlotMessage(FriendlyByteBuf buffer) {
        this.slotID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.changeType = buffer.readInt();
        this.meta = buffer.readInt();
    }

    public static void buffer(PowerStabilizerGUISlotMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }

    public static void handler(PowerStabilizerGUISlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int slotID = message.slotID;
            int changeType = message.changeType;
            int meta = message.meta;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PowerStabilizerGUISlotMessage.handleSlotAction((Player)entity, slotID, changeType, meta, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleSlotAction(Player entity, int slotID, int changeType, int meta, int x, int y, int z) {
        int amount;
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = PowerStabilizerGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (slotID == 0 && changeType == 0) {
            PowerStabilizerSlotChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slotID == 0 && changeType == 1) {
            PowerStabilizerSlotChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slotID == 0 && changeType == 2) {
            amount = meta;
            PowerStabilizerSlotChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slotID == 1 && changeType == 0) {
            PowerStabilizerSlotChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slotID == 1 && changeType == 1) {
            PowerStabilizerSlotChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slotID == 1 && changeType == 2) {
            amount = meta;
            PowerStabilizerSlotChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slotID == 2 && changeType == 0) {
            PowerStabilizerSlotChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slotID == 2 && changeType == 1) {
            PowerStabilizerSlotChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slotID == 2 && changeType == 2) {
            amount = meta;
            PowerStabilizerSlotChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoptechMod.addNetworkMessage(PowerStabilizerGUISlotMessage.class, PowerStabilizerGUISlotMessage::buffer, PowerStabilizerGUISlotMessage::new, PowerStabilizerGUISlotMessage::handler);
    }
}

