/*
 * Decompiled with CFR 0.152.
 */
package copper.technologies.pc.network;

import copper.technologies.pc.CoptechMod;
import copper.technologies.pc.procedures.PanelTurnedOffGUIProcedure;
import copper.technologies.pc.procedures.PlayConnectionProcedure;
import copper.technologies.pc.procedures.PlayRadioMusic1Procedure;
import copper.technologies.pc.procedures.PlayRadioMusic2Procedure;
import copper.technologies.pc.procedures.PlayRadioMusic3Procedure;
import copper.technologies.pc.procedures.PlayRadioMusic4Procedure;
import copper.technologies.pc.procedures.PlaySosProcedure;
import copper.technologies.pc.procedures.StopMusicRadioProcedure;
import copper.technologies.pc.world.inventory.RadioControlPanelInterfaceMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RadioControlPanelInterfaceButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public RadioControlPanelInterfaceButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public RadioControlPanelInterfaceButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(RadioControlPanelInterfaceButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(RadioControlPanelInterfaceButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            RadioControlPanelInterfaceButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = RadioControlPanelInterfaceMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            PanelTurnedOffGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            PlaySosProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            StopMusicRadioProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            PlayConnectionProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            PlayRadioMusic1Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            PlayRadioMusic2Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            PlayRadioMusic3Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            PlayRadioMusic4Procedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoptechMod.addNetworkMessage(RadioControlPanelInterfaceButtonMessage.class, RadioControlPanelInterfaceButtonMessage::buffer, RadioControlPanelInterfaceButtonMessage::new, RadioControlPanelInterfaceButtonMessage::handler);
    }
}

