/*
 * Decompiled with CFR 0.152.
 */
package copper.technologies.pc.network;

import copper.technologies.pc.CoptechMod;
import copper.technologies.pc.procedures.Channel1Procedure;
import copper.technologies.pc.procedures.Channel2Procedure;
import copper.technologies.pc.procedures.Channel3Procedure;
import copper.technologies.pc.procedures.Channel4Procedure;
import copper.technologies.pc.procedures.Channel5Procedure;
import copper.technologies.pc.procedures.Channel6Procedure;
import copper.technologies.pc.procedures.TVoffedProcedure;
import copper.technologies.pc.world.inventory.TvMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TvButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public TvButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public TvButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(TvButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(TvButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            TvButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = TvMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            TVoffedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            Channel1Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            Channel2Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            Channel3Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            Channel4Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            Channel5Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            Channel6Procedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoptechMod.addNetworkMessage(TvButtonMessage.class, TvButtonMessage::buffer, TvButtonMessage::new, TvButtonMessage::handler);
    }
}

