/*
 * Decompiled with CFR 0.152.
 */
package copper.technologies.pc.network;

import copper.technologies.pc.CoptechMod;
import copper.technologies.pc.procedures.TVstationChannelSelect2Procedure;
import copper.technologies.pc.procedures.TVstationChannelSelect3Procedure;
import copper.technologies.pc.procedures.TVstationChannelSelect4Procedure;
import copper.technologies.pc.procedures.TVstationChannelSelect5Procedure;
import copper.technologies.pc.procedures.TVstationChannelSelectProcedure;
import copper.technologies.pc.procedures.TvGUIbuttonChannelsProcedure;
import copper.technologies.pc.procedures.TvGUIbuttonInfoProcedure;
import copper.technologies.pc.procedures.TvGUIbuttonInstructionProcedure;
import copper.technologies.pc.procedures.TvGUIbuttonModeProcedure;
import copper.technologies.pc.world.inventory.TvStationChannelsMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TvStationChannelsButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public TvStationChannelsButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public TvStationChannelsButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(TvStationChannelsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(TvStationChannelsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            TvStationChannelsButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = TvStationChannelsMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            TvGUIbuttonInfoProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            TvGUIbuttonModeProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            TvGUIbuttonInstructionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            TvGUIbuttonChannelsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            TVstationChannelSelect2Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            TVstationChannelSelect3Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            TVstationChannelSelect4Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            TVstationChannelSelect5Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 8) {
            TVstationChannelSelectProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoptechMod.addNetworkMessage(TvStationChannelsButtonMessage.class, TvStationChannelsButtonMessage::buffer, TvStationChannelsButtonMessage::new, TvStationChannelsButtonMessage::handler);
    }
}

