/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class NeonBlock
extends HalfTransparentBlock {
    private static final int MAX_COMPONENT_SIZE = 1024;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public NeonBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(NeonBlock.litBlockEmission(15)).noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    private Set<BlockPos> collectConnectedLamps(Level level, BlockPos start, int maxSize) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(start);
        while (!queue.isEmpty() && visited.size() < maxSize) {
            BlockState bs;
            BlockPos pos = (BlockPos)queue.removeFirst();
            if (visited.contains(pos) || !((bs = level.getBlockState(pos)).getBlock() instanceof NeonBlock)) continue;
            visited.add(pos);
            for (Direction dir : Direction.values()) {
                BlockState ns;
                BlockPos np = pos.relative(dir);
                if (visited.contains(np) || !((ns = level.getBlockState(np)).getBlock() instanceof NeonBlock)) continue;
                queue.addLast(np);
            }
        }
        return visited;
    }

    private void updateComponent(Level level, BlockPos pos) {
        if (level.isClientSide) {
            return;
        }
        Set<BlockPos> component = this.collectConnectedLamps(level, pos, 1024);
        if (component.isEmpty()) {
            return;
        }
        boolean truncated = component.size() >= 1024;
        boolean anyPowered = false;
        for (BlockPos p : component) {
            if (!level.hasNeighborSignal(p)) continue;
            anyPowered = true;
            break;
        }
        if (truncated && !anyPowered) {
            anyPowered = true;
        }
        for (BlockPos p : component) {
            boolean isLit;
            BlockState bs = level.getBlockState(p);
            if (!(bs.getBlock() instanceof NeonBlock) || (isLit = ((Boolean)bs.getValue((Property)LIT)).booleanValue()) == anyPowered) continue;
            level.setBlock(p, (BlockState)bs.setValue((Property)LIT, (Comparable)Boolean.valueOf(anyPowered)), 2);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (level.isClientSide) {
            return;
        }
        level.scheduleTick(pos, (Block)this, 2);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moved) {
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 2);
        }
        super.onPlace(state, level, pos, oldState, moved);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide && state.getBlock() != newState.getBlock()) {
            for (Direction dir : Direction.values()) {
                BlockPos np = pos.relative(dir);
                BlockState ns = level.getBlockState(np);
                if (!(ns.getBlock() instanceof NeonBlock)) continue;
                level.scheduleTick(np, (Block)this, 2);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.updateComponent((Level)level, pos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return block -> (Boolean)block.getValue((Property)BlockStateProperties.LIT) != false ? lightValue : 0;
    }
}

