/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks;

import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RedstonePoleBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<RedstonePoleBlock> CODEC = RedstonePoleBlock.simpleCodec(RedstonePoleBlock::new);
    public static final EnumProperty<Axis> AXIS = EnumProperty.create((String)"axis", Axis.class);
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape SHAPE_Y = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_Z = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SHAPE_X = Block.box((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);

    public RedstonePoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RedstonePoleBlock() {
        super(BlockBehaviour.Properties.of().strength(5.0f, 6.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)((Object)Axis.Y))).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (((Axis)((Object)state.getValue(AXIS))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> SHAPE_X;
            case 1 -> SHAPE_Y;
            case 2 -> SHAPE_Z;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)((Object)Axis.fromDirection(direction)));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, POWER, POWERED});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!level.isClientSide && !oldState.is((Block)this)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock()) && !level.isClientSide) {
            this.updateConnectedPoles(level, pos, new HashSet<BlockPos>(), true);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.updatePowerState((Level)level, pos, state);
    }

    private void updatePowerState(Level level, BlockPos pos, BlockState state) {
        int newPower;
        int maxInputPower = this.getMaxInputPower(level, pos, state);
        int currentPower = (Integer)state.getValue((Property)POWER);
        boolean currentPowered = (Boolean)state.getValue((Property)POWERED);
        boolean shouldBePowered = maxInputPower > 0;
        int n = newPower = shouldBePowered ? Math.max(0, maxInputPower - 1) : 0;
        if (currentPower != newPower || currentPowered != shouldBePowered) {
            BlockState newState = (BlockState)((BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(shouldBePowered));
            level.setBlock(pos, newState, 3);
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.relative(direction);
                level.updateNeighborsAt(neighborPos, (Block)this);
            }
        }
    }

    private int getMaxInputPower(Level level, BlockPos pos, BlockState state) {
        Axis axis = (Axis)((Object)state.getValue(AXIS));
        int maxPower = 0;
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            int power = this.getNeighborPower(level, neighborPos, direction.getOpposite(), axis);
            maxPower = Math.max(maxPower, power);
        }
        return maxPower;
    }

    private int getNeighborPower(Level level, BlockPos pos, Direction fromDirection, Axis sourceAxis) {
        BlockState neighborState = level.getBlockState(pos);
        if (neighborState.getBlock() instanceof RedstonePoleBlock) {
            Axis neighborAxis = (Axis)((Object)neighborState.getValue(AXIS));
            if (neighborAxis == sourceAxis && ((Boolean)neighborState.getValue((Property)POWERED)).booleanValue()) {
                return (Integer)neighborState.getValue((Property)POWER);
            }
            return 0;
        }
        int directSignal = level.getDirectSignal(pos, fromDirection);
        int indirectSignal = level.getSignal(pos, fromDirection);
        return Math.max(directSignal, indirectSignal);
    }

    private void updateConnectedPoles(Level level, BlockPos startPos, Set<BlockPos> visited, boolean isRemoving) {
        if (visited.contains(startPos)) {
            return;
        }
        visited.add(startPos);
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = startPos.relative(direction);
            if (visited.contains(neighborPos)) continue;
            BlockState neighborState = level.getBlockState(neighborPos);
            if (neighborState.getBlock() instanceof RedstonePoleBlock) {
                level.scheduleTick(neighborPos, neighborState.getBlock(), 1);
                this.updateConnectedPoles(level, neighborPos, visited, isRemoving);
                continue;
            }
            level.updateNeighborsAt(neighborPos, (Block)this);
        }
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getSignal(state, level, pos, direction);
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return 0;
        }
        Axis axis = (Axis)((Object)state.getValue(AXIS));
        int power = (Integer)state.getValue((Property)POWER);
        Axis requestAxis = Axis.fromDirection(direction);
        if (requestAxis == axis) {
            return power;
        }
        return Math.max(0, power - 1);
    }

    public boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)POWER);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> {
                switch (((Axis)((Object)state.getValue(AXIS))).ordinal()) {
                    case 0: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)((Object)Axis.Z));
                    }
                    case 2: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)((Object)Axis.X));
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return direction != null;
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public static enum Axis implements StringRepresentable
    {
        X("x"),
        Y("y"),
        Z("z");

        private final String name;

        private Axis(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public Direction[] getDirections() {
            Direction[] directionArray;
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Direction[] directionArray2 = new Direction[2];
                    directionArray2[0] = Direction.EAST;
                    directionArray = directionArray2;
                    directionArray2[1] = Direction.WEST;
                    break;
                }
                case 1: {
                    Direction[] directionArray3 = new Direction[2];
                    directionArray3[0] = Direction.UP;
                    directionArray = directionArray3;
                    directionArray3[1] = Direction.DOWN;
                    break;
                }
                case 2: {
                    Direction[] directionArray4 = new Direction[2];
                    directionArray4[0] = Direction.NORTH;
                    directionArray = directionArray4;
                    directionArray4[1] = Direction.SOUTH;
                }
            }
            return directionArray;
        }

        public static Axis fromDirection(Direction direction) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.UP, Direction.DOWN -> Y;
                case Direction.NORTH, Direction.SOUTH -> Z;
                case Direction.EAST, Direction.WEST -> X;
            };
        }
    }
}

