/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xxrexraptorxx.citycraft.registry.ModBlocks;

public class SignalLightBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<SignalLightBlock> CODEC = MapCodec.unit(() -> new SignalLightBlock(BlockBehaviour.Properties.of()));
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SINGLE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape DOUBLE_SIDE_EAST_WEST = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0);
    private static final VoxelShape DOUBLE_SIDE_NORTH_SOUTH = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);

    public SignalLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends SignalLightBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection();
        boolean powered = context.getLevel().hasNeighborSignal(context.getClickedPos());
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean waterlogged = fluidState.getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)LIT, (Comparable)Boolean.valueOf(!powered))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this == ModBlocks.SIGNAL_LIGHT.get() || this == ModBlocks.PEDESTRIAN_SIGNAL_LIGHT.get()) {
            return SINGLE;
        }
        if (state.getValue((Property)FACING) == Direction.NORTH || state.getValue((Property)FACING) == Direction.SOUTH) {
            return DOUBLE_SIDE_NORTH_SOUTH;
        }
        return DOUBLE_SIDE_EAST_WEST;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean currentlyLit;
        boolean powered;
        if (!level.isClientSide && (powered = level.hasNeighborSignal(pos)) == (currentlyLit = ((Boolean)state.getValue((Property)LIT)).booleanValue())) {
            BlockState newState = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(!powered));
            level.setBlock(pos, newState, 3);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? 15 : 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }
}

