/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xxrexraptorxx.citycraft.utils.Enums.LightPhase;

public class TrafficLightBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<TrafficLightBlock> CODEC = MapCodec.unit(() -> new TrafficLightBlock(BlockBehaviour.Properties.of(), false));
    public static final EnumProperty<LightPhase> PHASE = EnumProperty.create((String)"phase", LightPhase.class);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final int RED_DURATION = 1000;
    private static final int GREEN_DURATION = 1000;
    private static final int RED_YELLOW_DURATION = 60;
    private static final int YELLOW_DURATION = 60;
    private static final int TOTAL_CYCLE_DURATION = 2120;
    private static final VoxelShape TRIPLE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape DOUBLE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private final boolean constructorInverted;

    public TrafficLightBlock(BlockBehaviour.Properties properties, boolean inverted) {
        super(properties);
        this.constructorInverted = inverted;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PHASE, (Comparable)((Object)this.calculatePhaseFromWorldTime(0L, Direction.NORTH, inverted)))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends TrafficLightBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PHASE, POWERED, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection();
        boolean powered = context.getLevel().hasNeighborSignal(context.getClickedPos());
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean waterlogged = fluidState.getType() == Fluids.WATER;
        LightPhase initialPhase = this.calculatePhaseFromWorldTime(context.getLevel().getGameTime(), facing, this.constructorInverted);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue(PHASE, (Comparable)((Object)(powered ? LightPhase.RED : initialPhase)))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        String blockName = BuiltInRegistries.BLOCK.getKey((Object)this).getPath();
        if (blockName.contains("triple")) {
            return TRIPLE;
        }
        if (blockName.contains("double")) {
            return DOUBLE;
        }
        return Shapes.block();
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            Direction facing;
            long worldTime = level.getGameTime();
            LightPhase currentPhase = this.calculatePhaseFromWorldTime(worldTime, facing = (Direction)state.getValue((Property)FACING), this.constructorInverted);
            if (currentPhase != state.getValue(PHASE)) {
                BlockState newState = (BlockState)state.setValue(PHASE, (Comparable)((Object)currentPhase));
                level.setBlock(pos, newState, 3);
            }
            int ticksUntilNextPhase = this.calculateTicksUntilNextPhase(worldTime, facing, this.constructorInverted);
            level.scheduleTick(pos, (Block)this, ticksUntilNextPhase);
        }
        super.onPlace(state, level, pos, oldState, isMoving);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean wasPowered;
        boolean powered = level.hasNeighborSignal(pos);
        if (powered != (wasPowered = ((Boolean)state.getValue((Property)POWERED)).booleanValue())) {
            BlockState newState = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered));
            if (powered) {
                newState = (BlockState)newState.setValue(PHASE, (Comparable)((Object)LightPhase.RED));
            }
            level.setBlock(pos, newState, 3);
            if (!powered) {
                long worldTime = level.getGameTime();
                Direction facing = (Direction)state.getValue((Property)FACING);
                LightPhase correctPhase = this.calculatePhaseFromWorldTime(worldTime, facing, this.constructorInverted);
                newState = (BlockState)newState.setValue(PHASE, (Comparable)((Object)correctPhase));
                level.setBlock(pos, newState, 3);
                int ticksUntilNextPhase = this.calculateTicksUntilNextPhase(worldTime, facing, this.constructorInverted);
                level.scheduleTick(pos, (Block)this, ticksUntilNextPhase);
            }
            return;
        }
        if (!powered) {
            long worldTime = level.getGameTime();
            Direction facing = (Direction)state.getValue((Property)FACING);
            LightPhase correctPhase = this.calculatePhaseFromWorldTime(worldTime, facing, this.constructorInverted);
            BlockState newState = (BlockState)state.setValue(PHASE, (Comparable)((Object)correctPhase));
            level.setBlock(pos, newState, 3);
            int ticksUntilNextPhase = this.calculateTicksUntilNextPhase(worldTime, facing, this.constructorInverted);
            level.scheduleTick(pos, (Block)this, ticksUntilNextPhase);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean wasPowered;
        boolean powered;
        if (!level.isClientSide && (powered = level.hasNeighborSignal(pos)) != (wasPowered = ((Boolean)state.getValue((Property)POWERED)).booleanValue())) {
            BlockState newState = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered));
            if (powered) {
                newState = (BlockState)newState.setValue(PHASE, (Comparable)((Object)LightPhase.RED));
            }
            level.setBlock(pos, newState, 3);
            if (powered) {
                level.getBlockTicks().willTickThisTick(pos, (Object)this);
            } else {
                long worldTime = level.getGameTime();
                Direction facing = (Direction)state.getValue((Property)FACING);
                LightPhase correctPhase = this.calculatePhaseFromWorldTime(worldTime, facing, this.constructorInverted);
                newState = (BlockState)newState.setValue(PHASE, (Comparable)((Object)correctPhase));
                level.setBlock(pos, newState, 3);
                int ticksUntilNextPhase = this.calculateTicksUntilNextPhase(worldTime, facing, this.constructorInverted);
                level.scheduleTick(pos, (Block)this, ticksUntilNextPhase);
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return 15;
        }
        LightPhase phase = (LightPhase)((Object)state.getValue(PHASE));
        return switch (phase) {
            default -> throw new MatchException(null, null);
            case LightPhase.RED -> 3;
            case LightPhase.RED_YELLOW -> 6;
            case LightPhase.YELLOW -> 9;
            case LightPhase.GREEN -> 12;
        };
    }

    private LightPhase calculatePhaseFromWorldTime(long worldTime, Direction facing, boolean constructorInverted) {
        long cycleTime = worldTime % 2120L;
        LightPhase basePhase = cycleTime < 1000L ? LightPhase.RED : (cycleTime < 1060L ? LightPhase.RED_YELLOW : (cycleTime < 2060L ? LightPhase.GREEN : LightPhase.YELLOW));
        boolean rotationInverted = this.isOppositeDirection(facing);
        if (rotationInverted) {
            basePhase = this.invertPhase(basePhase);
        }
        if (constructorInverted) {
            basePhase = this.invertPhase(basePhase);
        }
        return basePhase;
    }

    private int calculateTicksUntilNextPhase(long worldTime, Direction facing, boolean constructorInverted) {
        long cycleTime = worldTime % 2120L;
        int ticksInCurrentPhase = cycleTime < 1000L ? 1000 - (int)cycleTime : (cycleTime < 1060L ? 60 - (int)(cycleTime - 1000L) : (cycleTime < 2060L ? 1000 - (int)(cycleTime - 1000L - 60L) : 60 - (int)(cycleTime - 1000L - 60L - 1000L)));
        return Math.max(1, ticksInCurrentPhase);
    }

    private LightPhase invertPhase(LightPhase phase) {
        return switch (phase) {
            default -> throw new MatchException(null, null);
            case LightPhase.RED -> LightPhase.GREEN;
            case LightPhase.RED_YELLOW -> LightPhase.YELLOW;
            case LightPhase.GREEN -> LightPhase.RED;
            case LightPhase.YELLOW -> LightPhase.RED_YELLOW;
        };
    }

    private boolean isOppositeDirection(Direction facing) {
        return facing == Direction.SOUTH || facing == Direction.WEST;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }
}

