/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.entity_model_system.packets;

import com.finderfeed.fdlib.FDClientPacketExecutables;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.ModelAttachmentData;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.ModelAttachmentType;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

@RegisterFDPacket(value="fdlib:add_entity_attachment")
public class AddEntityAttachmentPacket
extends FDPacket {
    private int entityId;
    private int layer;
    private String bone;
    private UUID uuid;
    private ModelAttachmentData<?> modelAttachmentData;

    public AddEntityAttachmentPacket(Entity entity, int layer, String bone, UUID uuid, ModelAttachmentData<?> modelAttachmentData) {
        this.entityId = entity.m_19879_();
        this.layer = layer;
        this.bone = bone;
        this.uuid = uuid;
        this.modelAttachmentData = modelAttachmentData;
    }

    public AddEntityAttachmentPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.layer = buf.readInt();
        this.bone = buf.m_130277_();
        this.uuid = buf.m_130259_();
        ModelAttachmentType type = (ModelAttachmentType)FDRegistries.MODEL_ATTACHMENT_TYPES.get().getValue(buf.m_130281_());
        this.modelAttachmentData = (ModelAttachmentData)type.dataNetworkCodec().fromNetwork(buf);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.layer);
        buf.m_130070_(this.bone);
        buf.m_130077_(this.uuid);
        ModelAttachmentType<?, ?> type = this.modelAttachmentData.type();
        buf.m_130085_(FDRegistries.MODEL_ATTACHMENT_TYPES.get().getKey(type));
        this.hackyEncode(buf, type);
    }

    @Override
    public void clientAction(Supplier<NetworkEvent.Context> context) {
        FDClientPacketExecutables.addEntityAttachmentPacket(this.entityId, this.layer, this.bone, this.uuid, this.modelAttachmentData);
    }

    @Override
    public void serverAction(Supplier<NetworkEvent.Context> context) {
    }

    private <T extends ModelAttachmentData<?>> void hackyEncode(FriendlyByteBuf buf, ModelAttachmentType<?, T> type) {
        type.dataNetworkCodec().toNetwork(buf, this.modelAttachmentData);
    }
}

