/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.entity.action_chain;

import com.finderfeed.fdlib.systems.entity.action_chain.Attack;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackAction;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackDefinition;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackExecutor;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackInstance;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackOptions;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class AttackChain {
    private HashMap<String, AttackExecutor> registeredAttackExecutors = new HashMap();
    private List<Pair<Integer, AttackOptions<?>>> attackOptions = new ArrayList();
    private List<Pair<Supplier<Boolean>, String>> alwaysTryCastAttacks = new ArrayList<Pair<Supplier<Boolean>, String>>();
    private Queue<String> chain = new ArrayDeque<String>();
    private AttackInstance currentAttack = null;
    private Function<String, AttackAction> attackListener = inst -> AttackAction.PROCEED;
    private RandomSource source;

    public AttackChain(RandomSource source) {
        this.source = source;
    }

    public AttackChain registerInClassAttacks(Class<? extends Entity> entityClass) {
        for (Method method : entityClass.getDeclaredMethods()) {
            Attack attack = method.getAnnotation(Attack.class);
            if (attack == null) continue;
            method.setAccessible(true);
            this.registerAttack(attack.value(), instance -> {
                try {
                    return (Boolean)method.invoke((Object)instance, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return this;
    }

    public AttackChain addAlwaysTryCastAttack(Supplier<Boolean> condition, String attack) {
        this.alwaysTryCastAttacks.add((Pair<Supplier<Boolean>, String>)new Pair(condition, (Object)attack));
        return this;
    }

    public AttackChain attackListener(Function<String, AttackAction> listener) {
        this.attackListener = listener;
        return this;
    }

    public AttackChain registerAttack(String name, AttackExecutor executor) {
        this.registeredAttackExecutors.put(name, executor);
        return this;
    }

    public AttackChain addAttack(int priority, AttackOptions options) {
        this.attackOptions.add(new Pair((Object)priority, (Object)options));
        this.attackOptions.sort(Comparator.comparingInt(Pair::getFirst));
        return this;
    }

    public AttackChain addAttack(int priority, String attack) {
        return this.addAttack(priority, AttackOptions.builder().addAttack(attack).build());
    }

    public void tick() {
        if (this.chain.isEmpty() && this.currentAttack == null) {
            this.buildQueue();
        } else if (this.currentAttack != null) {
            int previousStage = this.currentAttack.stage;
            if (this.currentAttack.attack.execute(this.currentAttack)) {
                this.currentAttack = null;
                this.pollAndExecuteAttack();
            } else if (this.currentAttack.stage == previousStage) {
                ++this.currentAttack.tick;
            }
        } else {
            this.pollAndExecuteAttack();
        }
    }

    private boolean tryCastAlwaysAttack() {
        for (Pair<Supplier<Boolean>, String> attack : this.alwaysTryCastAttacks) {
            Supplier predicate = (Supplier)attack.getFirst();
            if (!((Boolean)predicate.get()).booleanValue()) continue;
            String attackName = (String)attack.getSecond();
            this.currentAttack = new AttackInstance(attackName, this.registeredAttackExecutors.get(attackName));
            return true;
        }
        return false;
    }

    private void pollAndExecuteAttack() {
        String executorName;
        AttackAction attackAction;
        while (this.currentAttack == null && !this.chain.isEmpty() && (attackAction = this.attackListener.apply(executorName = this.chain.peek())) != AttackAction.WAIT) {
            if (attackAction == AttackAction.SKIP) {
                this.chain.poll();
                continue;
            }
            if (attackAction != AttackAction.PROCEED) break;
            if (this.tryCastAlwaysAttack()) {
                return;
            }
            this.chain.poll();
            AttackExecutor executor = this.registeredAttackExecutors.get(executorName);
            if (executor == null) {
                throw new RuntimeException("Attack not registered: " + executorName);
            }
            this.currentAttack = new AttackInstance(executorName, executor);
            if (this.currentAttack.attack.execute(this.currentAttack)) {
                this.currentAttack = null;
                continue;
            }
            if (this.currentAttack.stage != 0) continue;
            ++this.currentAttack.tick;
        }
    }

    public void buildQueue() {
        this.chain.clear();
        ArrayList<AttackOptions> samePriority = new ArrayList<AttackOptions>();
        int currentValue = (Integer)this.attackOptions.get(0).getFirst();
        for (Pair<Integer, AttackOptions<?>> pair : this.attackOptions) {
            if ((Integer)pair.getFirst() == currentValue) {
                samePriority.add((AttackOptions)pair.getSecond());
                continue;
            }
            this.addSamePriorityOptionsToQueue(samePriority);
            samePriority.add((AttackOptions)pair.getSecond());
            currentValue = (Integer)pair.getFirst();
        }
        this.addSamePriorityOptionsToQueue(samePriority);
    }

    private void addSamePriorityOptionsToQueue(List<AttackOptions> samePriority) {
        while (!samePriority.isEmpty()) {
            int rndid = this.source.m_188503_(samePriority.size());
            AttackOptions options = samePriority.get(rndid);
            this.addOptionsToQueue(options);
            samePriority.remove(rndid);
        }
    }

    private void addOptionsToQueue(AttackOptions options) {
        AttackOptions<?> pre = options.getPreAttackOptions();
        if (pre != null) {
            this.addOptionsToQueue(pre);
        }
        for (AttackOptions<?> next = options; next != null; next = next.getNextAttackOptions()) {
            Collection definitions = next.getAttacks(this.source);
            for (AttackDefinition definition : definitions) {
                if (definition.getExecutorName() != null) {
                    this.chain.offer(definition.getExecutorName());
                    continue;
                }
                this.addOptionsToQueue(definition.getOptions());
            }
        }
    }

    public void reset() {
        this.currentAttack = null;
        this.chain.clear();
    }

    public AttackInstance getCurrentAttack() {
        return this.currentAttack;
    }

    public void load(CompoundTag tag) {
        int index = 0;
        while (tag.m_128441_("attack_" + index)) {
            this.chain.offer(tag.m_128461_("attack_" + index));
            ++index;
        }
        if (tag.m_128441_("currentAttack")) {
            String name = tag.m_128461_("currentAttack");
            int tick = tag.m_128451_("currentAttackTick");
            int stage = tag.m_128451_("currentAttackStage");
            AttackExecutor executor = this.registeredAttackExecutors.get(name);
            AttackInstance instance = new AttackInstance(name, executor);
            instance.tick = tick;
            instance.stage = stage;
            this.currentAttack = instance;
        }
    }

    public void save(CompoundTag tag) {
        int index = 0;
        for (String s : this.chain) {
            tag.m_128359_("attack_" + index++, s);
        }
        if (this.currentAttack != null) {
            tag.m_128359_("currentAttack", this.currentAttack.name);
            tag.m_128405_("currentAttackTick", this.currentAttack.tick);
            tag.m_128405_("currentAttackStage", this.currentAttack.stage);
        }
    }
}

