/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.client;

import java.util.Collections;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.g_skyrim.rpglevel.client.hud.RestrictionNoticeHud;
import org.g_skyrim.rpglevel.client.screen.SkillsScreen;
import org.g_skyrim.rpglevel.clientcache.ClientSkillsCache;
import org.g_skyrim.rpglevel.network.RestrictionNoticePacket;
import org.g_skyrim.rpglevel.network.RpgNetwork;
import org.g_skyrim.rpglevel.restrictions.RestrictionEngine;

@Environment(value=EnvType.CLIENT)
public class RpglevelClient
implements ClientModInitializer {
    private static class_304 openSkills;

    public static class_304 getOpenSkillsKey() {
        return openSkills;
    }

    public void onInitializeClient() {
        RestrictionNoticeHud.init();
        openSkills = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.rpglevel.open_skills", class_3675.class_307.field_1668, 75, "category.rpglevel"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (openSkills.method_1436()) {
                if (client.field_1724 == null) continue;
                if (client.field_1755 instanceof SkillsScreen) {
                    client.method_1507(null);
                    continue;
                }
                client.method_1507((class_437)new SkillsScreen());
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> ClientPlayNetworking.send((class_2960)RpgNetwork.REQ_SNAPSHOT, (class_2540)PacketByteBufs.empty()));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> ClientSkillsCache.setSnapshot(Collections.emptyMap()));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RpgNetwork.SNAPSHOT, (client, handler, buf, responseSender) -> SkillsScreen.handleSnapshotPacket(buf));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RestrictionNoticePacket.ID, (client, handler, buf, responseSender) -> {
            class_2960 skillId = buf.method_10810();
            int req = buf.method_10816();
            int cur = buf.method_10816();
            client.execute(() -> RestrictionNoticeHud.get().push(skillId, req, cur));
        });
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
            Map<class_2960, Integer> reqs;
            if (stack == null || stack.method_7960()) {
                return;
            }
            class_1792 item = stack.method_7909();
            class_2248 block = null;
            if (item instanceof class_1747) {
                class_1747 bi = (class_1747)item;
                block = bi.method_7711();
            }
            if ((reqs = RestrictionEngine.get().collectRequirementsForTooltip(item, block)).isEmpty()) {
                return;
            }
            lines.add(class_2561.method_43470((String)"Restrictions:").method_27692(class_124.field_1080));
            for (Map.Entry<class_2960, Integer> e : reqs.entrySet()) {
                class_2960 skillId = e.getKey();
                int neededLvl = e.getValue();
                int currentLvl = ClientSkillsCache.getLevel(skillId);
                Object name = skillId.method_12832().replace('_', ' ');
                if (!((String)name).isEmpty()) {
                    name = Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
                }
                boolean ok = currentLvl >= neededLvl;
                class_5250 line = ok ? class_2561.method_43470((String)(" - " + (String)name + ": " + neededLvl)).method_27692(class_124.field_1077) : class_2561.method_43470((String)(" - " + (String)name + ": " + neededLvl + " (" + currentLvl + "/" + neededLvl + ")")).method_27692(class_124.field_1061);
                lines.add(line);
            }
        });
    }
}

