/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.client.hud;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.g_skyrim.rpglevel.client.hud.SkillIconUtil;

@Environment(value=EnvType.CLIENT)
public final class RestrictionNoticeHud
implements HudRenderCallback {
    private static final RestrictionNoticeHud INSTANCE = new RestrictionNoticeHud();
    private static final long DURATION_MS = 2000L;
    private final Deque<Notice> queue = new ArrayDeque<Notice>();

    public static void init() {
        HudRenderCallback.EVENT.register((Object)INSTANCE);
    }

    public static RestrictionNoticeHud get() {
        return INSTANCE;
    }

    public void push(class_2960 skillId, int required, int current) {
        this.queue.removeIf(n -> n.skillId.equals((Object)skillId));
        this.queue.addLast(new Notice(skillId, required, current));
    }

    public void onHudRender(class_332 ctx, float tickDelta) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        while (!this.queue.isEmpty() && this.queue.peekFirst().until <= now) {
            this.queue.removeFirst();
        }
        if (this.queue.isEmpty()) {
            return;
        }
        Notice n = this.queue.peekFirst();
        int sw = ctx.method_51421();
        int sh = ctx.method_51443();
        String text = "Level " + n.req + " needed";
        int textW = mc.field_1772.method_1727(text);
        int padL = 6;
        int padR = 8;
        int padT = 4;
        int padB = 4;
        int iconSize = 16;
        int gap = 6;
        int panelW = padL + iconSize + gap + textW + padR;
        int minW = 84;
        if (panelW < minW) {
            panelW = minW;
        }
        Objects.requireNonNull(mc.field_1772);
        int panelH = Math.max(padT + Math.max(iconSize, 9) + padB, 20);
        int x = (sw - panelW) / 2;
        int y = sh - 60;
        int bg = -1441722095;
        int border = 0x55FFFFFF;
        ctx.method_25294(x, y, x + panelW, y + panelH, bg);
        ctx.method_49601(x, y, panelW, panelH, border);
        class_1799 icon = SkillIconUtil.iconFor(n.skillId);
        int iconX = x + padL;
        int iconY = y + (panelH - iconSize) / 2;
        ctx.method_51427(icon, iconX, iconY);
        int color = -3092272;
        int textX = iconX + iconSize + gap;
        Objects.requireNonNull(mc.field_1772);
        int textY = y + (panelH - 9) / 2;
        ctx.method_51439(mc.field_1772, (class_2561)class_2561.method_43470((String)text), textX, textY, color, false);
    }

    @Environment(value=EnvType.CLIENT)
    private static final class Notice {
        final class_2960 skillId;
        final int req;
        final int cur;
        final long until;

        Notice(class_2960 skillId, int req, int cur) {
            this.skillId = skillId;
            this.req = req;
            this.cur = cur;
            this.until = System.currentTimeMillis() + 2000L;
        }
    }
}

