/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.client.screen;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.g_skyrim.rpglevel.client.screen.SkillsScreen;
import org.g_skyrim.rpglevel.clientcache.ClientSkillsCache;
import org.g_skyrim.rpglevel.restrictions.RestrictionEngine;
import org.g_skyrim.rpglevel.skills.SkillDefinition;
import org.g_skyrim.rpglevel.skills.SkillRegistry;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class SkillDetailScreen
extends class_437 {
    private final class_2960 skillId;
    private int scrollY = 0;
    private int contentHeight = 0;
    private class_4185 backButton;
    private static final Map<class_2960, List<class_1799>> ITEM_TAG_CACHE = new HashMap<class_2960, List<class_1799>>();
    private static final Map<class_2960, List<class_1799>> BLOCK_TAG_CACHE = new HashMap<class_2960, List<class_1799>>();

    public SkillDetailScreen(class_2960 skillId) {
        super((class_2561)class_2561.method_43473());
        this.skillId = skillId;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), b -> class_310.method_1551().method_1507((class_437)new SkillsScreen())).method_46434(0, 0, 60, 20).method_46431();
        this.method_37063((class_364)this.backButton);
    }

    private static String prettyName(class_2960 id) {
        String path = id.method_12832().replace('_', ' ');
        if (path.isEmpty()) {
            return id.toString();
        }
        return Character.toUpperCase(path.charAt(0)) + path.substring(1);
    }

    private static class_1799 iconFor(class_2960 id) {
        return SkillDetailScreen.getItemStack(id);
    }

    @NotNull
    static class_1799 getItemStack(class_2960 id) {
        String p;
        return switch (p = id.method_12832()) {
            case "mining" -> new class_1799((class_1935)class_1802.field_8403);
            case "woodcutting" -> new class_1799((class_1935)class_1802.field_8475);
            case "farming" -> new class_1799((class_1935)class_1802.field_8861);
            case "fishing" -> new class_1799((class_1935)class_1802.field_8378);
            case "combat" -> new class_1799((class_1935)class_1802.field_8371);
            case "archery" -> new class_1799((class_1935)class_1802.field_8102);
            case "defense" -> new class_1799((class_1935)class_1802.field_8523);
            case "crafting" -> new class_1799((class_1935)class_1802.field_8465);
            case "agility" -> new class_1799((class_1935)class_1802.field_8073);
            case "endurance" -> new class_1799((class_1935)class_1802.field_8176);
            case "healing" -> new class_1799((class_1935)class_1802.field_8463);
            case "luck" -> new class_1799((class_1935)class_1802.field_8687);
            default -> new class_1799((class_1935)class_1802.field_8407);
        };
    }

    private static List<class_1799> expandItemTag(class_2960 tagId) {
        List<class_1799> cached = ITEM_TAG_CACHE.get(tagId);
        if (cached != null) {
            return cached;
        }
        LinkedHashSet<class_1799> stacks = new LinkedHashSet<class_1799>();
        class_6862 key = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)tagId);
        try {
            for (class_1792 item : class_7923.field_41178) {
                class_6880 entry = class_7923.field_41178.method_47983((Object)item);
                if (entry == null || !entry.method_40220(key) || item == class_1802.field_8162) continue;
                stacks.add(new class_1799((class_1935)item));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (stacks.isEmpty()) {
            try {
                class_1792 asItem = (class_1792)class_7923.field_41178.method_10223(tagId);
                if (asItem != class_1802.field_8162) {
                    stacks.add(new class_1799((class_1935)asItem));
                }
            }
            catch (Throwable asItem) {
                // empty catch block
            }
        }
        ArrayList<class_1799> list = new ArrayList<class_1799>(stacks);
        ITEM_TAG_CACHE.put(tagId, list);
        return list;
    }

    private static List<class_1799> expandBlockTag(class_2960 tagId) {
        List<class_1799> cached = BLOCK_TAG_CACHE.get(tagId);
        if (cached != null) {
            return cached;
        }
        LinkedHashSet<class_1799> stacks = new LinkedHashSet<class_1799>();
        class_6862 key = class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)tagId);
        try {
            for (class_2248 block : class_7923.field_41175) {
                class_1792 asItem;
                class_6880 entry = class_7923.field_41175.method_47983((Object)block);
                if (entry == null || !entry.method_40220(key) || (asItem = block.method_8389()) == null || asItem == class_1802.field_8162) continue;
                stacks.add(new class_1799((class_1935)asItem));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (stacks.isEmpty()) {
            try {
                List<class_1799> asItems = SkillDetailScreen.expandItemTag(tagId);
                if (!asItems.isEmpty()) {
                    BLOCK_TAG_CACHE.put(tagId, new ArrayList<class_1799>(asItems));
                    return asItems;
                }
            }
            catch (Throwable asItems) {
                // empty catch block
            }
        }
        ArrayList<class_1799> list = new ArrayList<class_1799>(stacks);
        BLOCK_TAG_CACHE.put(tagId, list);
        return list;
    }

    private List<Row> buildRows() {
        ArrayList<Row> rows = new ArrayList<Row>();
        Map<Integer, List<RestrictionEngine.ViewSpec>> grouped = RestrictionEngineView.Accessor.collectRawForSkill(this.skillId);
        ArrayList<Integer> levels = new ArrayList<Integer>(grouped.keySet());
        Collections.sort(levels);
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            List<class_1799> ex;
            int lvl = (Integer)iterator.next();
            List specs = grouped.getOrDefault(lvl, List.of());
            if (lvl == 0 && (specs == null || specs.isEmpty())) continue;
            rows.add(Row.header(lvl));
            LinkedHashSet<class_2960> itemIds = new LinkedHashSet<class_2960>();
            LinkedHashSet<class_2960> blockIds = new LinkedHashSet<class_2960>();
            LinkedHashSet<class_2960> itemTags = new LinkedHashSet<class_2960>();
            LinkedHashSet<class_2960> blockTags = new LinkedHashSet<class_2960>();
            for (RestrictionEngine.ViewSpec spec : specs) {
                if (spec.itemIds() != null) {
                    itemIds.addAll(spec.itemIds());
                }
                if (spec.blockIds() != null) {
                    blockIds.addAll(spec.blockIds());
                }
                if (spec.itemTags() != null) {
                    itemTags.addAll(spec.itemTags());
                }
                if (spec.blockTags() == null) continue;
                blockTags.addAll(spec.blockTags());
            }
            LinkedHashMap<class_2960, class_1799> itemsFromItems = new LinkedHashMap<class_2960, class_1799>();
            LinkedHashMap<class_2960, class_1799> itemsFromBlocks = new LinkedHashMap<class_2960, class_1799>();
            ArrayList<List<class_1799>> rotatingFromBlockTags = new ArrayList<List<class_1799>>();
            ArrayList<CallSite> unresolvedItemTags = new ArrayList<CallSite>();
            ArrayList<CallSite> unresolvedBlockTags = new ArrayList<CallSite>();
            for (class_2960 iid : itemIds) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(iid);
                if (item == class_1802.field_8162) continue;
                itemsFromItems.putIfAbsent(iid, new class_1799((class_1935)item));
            }
            for (class_2960 bid : blockIds) {
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(bid);
                class_1792 asItem = block.method_8389();
                if (asItem == null || asItem == class_1802.field_8162) continue;
                class_2960 class_29602 = class_7923.field_41178.method_10221((Object)asItem);
                itemsFromBlocks.putIfAbsent(class_29602, new class_1799((class_1935)asItem));
            }
            for (class_2960 t : itemTags) {
                ex = SkillDetailScreen.expandItemTag(t);
                if (!ex.isEmpty()) {
                    for (class_1799 class_17992 : ex) {
                        class_2960 key = class_7923.field_41178.method_10221((Object)class_17992.method_7909());
                        itemsFromItems.putIfAbsent(key, class_17992);
                    }
                    continue;
                }
                unresolvedItemTags.add((CallSite)((Object)("#" + t.toString())));
            }
            for (class_2960 t : blockTags) {
                ex = SkillDetailScreen.expandBlockTag(t);
                if (!ex.isEmpty()) {
                    ex.sort((a, b) -> {
                        String bn;
                        String an = a.method_7964().getString();
                        int c = an.compareToIgnoreCase(bn = b.method_7964().getString());
                        if (c != 0) {
                            return c;
                        }
                        class_2960 ai = class_7923.field_41178.method_10221((Object)a.method_7909());
                        class_2960 bi = class_7923.field_41178.method_10221((Object)b.method_7909());
                        return ai.toString().compareToIgnoreCase(bi.toString());
                    });
                    rotatingFromBlockTags.add(ex);
                    continue;
                }
                unresolvedBlockTags.add((CallSite)((Object)("#" + t.toString())));
            }
            ArrayList itemGroup = new ArrayList(itemsFromItems.values());
            ArrayList blockGroup = new ArrayList(itemsFromBlocks.values());
            Comparator stackCmp = (a, b) -> {
                String bn;
                String an = a.method_7964().getString();
                int c = an.compareToIgnoreCase(bn = b.method_7964().getString());
                if (c != 0) {
                    return c;
                }
                class_2960 ai = class_7923.field_41178.method_10221((Object)a.method_7909());
                class_2960 bi = class_7923.field_41178.method_10221((Object)b.method_7909());
                String as = ai.toString();
                String bs = bi.toString();
                return as.compareToIgnoreCase(bs);
            };
            itemGroup.sort(stackCmp);
            blockGroup.sort(stackCmp);
            unresolvedItemTags.sort(String::compareToIgnoreCase);
            unresolvedBlockTags.sort(String::compareToIgnoreCase);
            for (class_1799 class_17993 : itemGroup) {
                rows.add(Row.item(lvl, class_17993));
            }
            for (String string : unresolvedItemTags) {
                rows.add(Row.tag(lvl, string));
            }
            for (class_1799 class_17994 : blockGroup) {
                rows.add(Row.item(lvl, class_17994));
            }
            for (List list : rotatingFromBlockTags) {
                rows.add(Row.rotate(lvl, list));
            }
            for (String string : unresolvedBlockTags) {
                rows.add(Row.tag(lvl, string));
            }
        }
        return rows;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int panelLeft = Math.max(10, this.field_22789 / 2 - 200);
        int panelRight = Math.min(this.field_22789 - 10, this.field_22789 / 2 + 200);
        int panelTop = Math.max(10, this.field_22790 / 2 - 110);
        int panelBottom = Math.min(this.field_22790 - 10, this.field_22790 / 2 + 110);
        int y = panelTop + 10;
        int textY = y + 24;
        int wrapWidth = panelRight - panelLeft - 24;
        SkillDefinition def = SkillRegistry.get(this.skillId).orElse(null);
        String desc = def != null ? def.description() : "";
        String how = def != null ? def.howTo() : "";
        textY += this.measureTextBlockHeight(wrapWidth, desc, how);
        List<Row> rows = this.buildRows();
        boolean hasContent = this.hasNonHeader(rows);
        if (!hasContent) {
            this.scrollY = 0;
            return true;
        }
        textY += 6;
        Objects.requireNonNull(this.field_22793);
        int listTop = textY += 9 + 4;
        int listBottom = panelBottom - 12;
        this.contentHeight = this.getTotal(rows);
        int viewH = Math.max(0, listBottom - listTop);
        int maxScroll = this.computeMaxScroll(viewH);
        this.scrollY = (int)Math.max(0.0, Math.min((double)maxScroll, (double)this.scrollY - amount * 20.0));
        return true;
    }

    private int getTotal(List<Row> rows) {
        Objects.requireNonNull(this.field_22793);
        int LINE_H = 9 + 2;
        int ITEM_H = 20;
        int GROUP_GAP = 6;
        int total = 0;
        boolean seenHeader = false;
        for (Row r : rows) {
            if (r.type == RowType.HEADER) {
                if (seenHeader) {
                    total += 6;
                }
                total += LINE_H;
                seenHeader = true;
                continue;
            }
            if (r.type == RowType.ITEM) {
                total += 20;
                continue;
            }
            if (r.type == RowType.ROTATE) {
                total += 20;
                continue;
            }
            total += LINE_H;
        }
        return total;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        int panelLeft = Math.max(10, this.field_22789 / 2 - 200);
        int panelRight = Math.min(this.field_22789 - 10, this.field_22789 / 2 + 200);
        int panelTop = Math.max(10, this.field_22790 / 2 - 110);
        int panelBottom = Math.min(this.field_22790 - 10, this.field_22790 / 2 + 110);
        SkillDetailScreen.fillRounded(context, panelLeft, panelTop, panelRight, panelBottom, -871362544);
        SkillDetailScreen.drawRoundedBorder(context, panelLeft, panelTop, panelRight, panelBottom, -12566464);
        int x = panelLeft + 12;
        int y = panelTop + 10;
        if (this.backButton != null) {
            int btnW = this.backButton.method_25368();
            int btnH = this.backButton.method_25364();
            int btnX = Math.max(panelLeft + 12, panelRight - 12 - btnW);
            int btnY = Math.max(panelTop + 6, Math.min(panelBottom - 6 - btnH, y));
            this.backButton.method_46421(btnX);
            this.backButton.method_46419(btnY);
        }
        context.method_51427(SkillDetailScreen.iconFor(this.skillId), x, y);
        String name = SkillDetailScreen.prettyName(this.skillId);
        int level = ClientSkillsCache.getLevel(this.skillId);
        context.method_25303(this.field_22793, name + " (Lvl " + level + ")", x + 22, y + 4, 0xFFFFFF);
        SkillDefinition def = SkillRegistry.get(this.skillId).orElse(null);
        String desc = def != null ? def.description() : "";
        String how = def != null ? def.howTo() : "";
        int textX = panelLeft + 12;
        int textY = y + 24;
        int wrapWidth = panelRight - panelLeft - 24;
        if (!desc.isEmpty()) {
            for (class_5481 line : this.field_22793.method_1728((class_5348)class_2561.method_43470((String)desc), wrapWidth)) {
                context.method_51430(this.field_22793, line, textX, textY, -5197648, false);
                Objects.requireNonNull(this.field_22793);
                textY += 9 + 2;
            }
        }
        if (!how.isEmpty()) {
            textY += 2;
            for (class_5481 line : this.field_22793.method_1728((class_5348)class_2561.method_43470((String)("How to level: " + how)), wrapWidth)) {
                context.method_51430(this.field_22793, line, textX, textY, -5189504, false);
                Objects.requireNonNull(this.field_22793);
                textY += 9 + 2;
            }
        }
        List<Row> rows = this.buildRows();
        boolean hasContent = this.hasNonHeader(rows);
        textY += 6;
        if (!hasContent) {
            context.method_25303(this.field_22793, "No restrictions for this skill in place", textX, textY, -5197648);
        } else {
            context.method_25303(this.field_22793, "Restrictions requiring this skill:", textX, textY, -2052096);
            Objects.requireNonNull(this.field_22793);
            int listTop = textY += 9 + 4;
            int listRight = panelRight - 12;
            int listBottom = panelBottom - 12;
            Objects.requireNonNull(this.field_22793);
            int LINE_H = 9 + 2;
            int ITEM_H = 20;
            int GROUP_GAP = 6;
            this.contentHeight = this.getTotal(rows);
            int viewH = Math.max(0, listBottom - listTop);
            int maxScroll = this.computeMaxScroll(viewH);
            this.scrollY = Math.max(0, Math.min(this.scrollY, maxScroll));
            context.method_44379(textX, listTop, listRight, listBottom);
            int drawY = listTop - this.scrollY;
            int levelColor = -7876870;
            boolean drewHeader = false;
            @Environment(value=EnvType.CLIENT)
            record Hit(int x, int y, int w, int h, class_1799 s) {
            }
            ArrayList<Hit> hits = new ArrayList<Hit>();
            for (Row r : rows) {
                if (r.type == RowType.HEADER) {
                    if (drewHeader) {
                        drawY += 6;
                    }
                    context.method_51433(this.field_22793, r.text, textX, drawY, levelColor, false);
                    drawY += LINE_H;
                    drewHeader = true;
                    continue;
                }
                if (r.type == RowType.ITEM) {
                    int iconY = drawY + 2;
                    context.method_51427(r.stack, textX, iconY);
                    String itemName = r.stack.method_7964().getString();
                    context.method_51433(this.field_22793, itemName, textX + 20, drawY + 4, -2236963, false);
                    hits.add(new Hit(textX, drawY, listRight - textX, 20, r.stack));
                    drawY += 20;
                    continue;
                }
                if (r.type == RowType.ROTATE) {
                    List<class_1799> cycle = r.cycle;
                    class_1799 cur = class_1799.field_8037;
                    if (cycle != null && !cycle.isEmpty()) {
                        long millis = System.currentTimeMillis();
                        int idx = (int)(millis / 2000L % (long)cycle.size());
                        cur = cycle.get(Math.max(0, Math.min(idx, cycle.size() - 1)));
                    }
                    int iconY = drawY + 2;
                    context.method_51427(cur, textX, iconY);
                    String itemName = cur.method_7960() ? "#block tag" : cur.method_7964().getString();
                    context.method_51433(this.field_22793, itemName, textX + 20, drawY + 4, -2236963, false);
                    hits.add(new Hit(textX, drawY, listRight - textX, 20, cur));
                    drawY += 20;
                    continue;
                }
                context.method_51433(this.field_22793, r.text, textX, drawY, -4473925, false);
                drawY += LINE_H;
            }
            context.method_44380();
            if (this.contentHeight > viewH) {
                int trackLeft = listRight - 6;
                int trackRight = listRight - 2;
                context.method_25294(trackLeft, listTop, trackRight, listBottom, 0x40202020);
                int scrollRange = Math.max(1, this.computeMaxScroll(viewH));
                int thumbH = Math.max(16, (int)((long)viewH * (long)viewH / (long)Math.max(1, this.contentHeight)));
                int travel = Math.max(0, listBottom - listTop - thumbH);
                int thumbY = listTop + (travel == 0 ? 0 : (int)((long)this.scrollY * (long)travel / (long)scrollRange));
                int thumbColor = -9408400;
                int thumbEdge = -7303024;
                context.method_25294(trackLeft + 1, thumbY + 1, trackRight - 1, thumbY + thumbH - 1, thumbColor);
                context.method_25294(trackLeft, thumbY, trackRight, thumbY + 1, thumbEdge);
                context.method_25294(trackLeft, thumbY + thumbH - 1, trackRight, thumbY + thumbH, thumbEdge);
                context.method_25294(trackLeft, thumbY, trackLeft + 1, thumbY + thumbH, thumbEdge);
                context.method_25294(trackRight - 1, thumbY, trackRight, thumbY + thumbH, thumbEdge);
            }
            for (Hit h : hits) {
                if (mouseX < h.x || mouseX >= h.x + h.w || mouseY < h.y || mouseY >= h.y + h.h) continue;
                context.method_51446(this.field_22793, h.s, mouseX, mouseY);
                break;
            }
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private static void fillRounded(class_332 ctx, int left, int top, int right, int bottom, int color) {
        ctx.method_25294(left, top + 2, right, bottom - 2, color);
        ctx.method_25294(left + 2, top, right - 2, top + 2, color);
        ctx.method_25294(left + 2, bottom - 2, right - 2, bottom, color);
    }

    private static void drawRoundedBorder(class_332 ctx, int left, int top, int right, int bottom, int color) {
        SkillDetailScreen.drawPanelLayout(ctx, left, top, right, bottom, color);
    }

    static void drawPanelLayout(class_332 ctx, int left, int top, int right, int bottom, int color) {
        ctx.method_25294(left + 2, top, right - 2, top + 1, color);
        ctx.method_25294(left + 2, bottom - 1, right - 2, bottom, color);
        ctx.method_25294(left, top + 2, left + 1, bottom - 2, color);
        ctx.method_25294(right - 1, top + 2, right, bottom - 2, color);
        ctx.method_25294(left + 1, top + 1, left + 2, top + 2, color);
        ctx.method_25294(right - 2, top + 1, right - 1, top + 2, color);
        ctx.method_25294(left + 1, bottom - 2, left + 2, bottom - 1, color);
        ctx.method_25294(right - 2, bottom - 2, right - 1, bottom - 1, color);
    }

    private int computeMaxScroll(int viewH) {
        return Math.max(0, this.contentHeight - viewH);
    }

    private boolean hasNonHeader(List<Row> rows) {
        for (Row r : rows) {
            if (r.type == RowType.HEADER) continue;
            return true;
        }
        return false;
    }

    private int measureTextBlockHeight(int wrapWidth, String desc, String how) {
        int total = 0;
        if (desc != null && !desc.isEmpty()) {
            for (class_5481 ignored : this.field_22793.method_1728((class_5348)class_2561.method_43470((String)desc), wrapWidth)) {
                Objects.requireNonNull(this.field_22793);
                total += 9 + 2;
            }
        }
        if (how != null && !how.isEmpty()) {
            total += 2;
            for (class_5481 ignored : this.field_22793.method_1728((class_5348)class_2561.method_43470((String)("How to level: " + how)), wrapWidth)) {
                Objects.requireNonNull(this.field_22793);
                total += 9 + 2;
            }
        }
        return total;
    }

    @Environment(value=EnvType.CLIENT)
    public static final class RestrictionEngineView {

        @Environment(value=EnvType.CLIENT)
        public static interface Accessor {
            public static Map<Integer, List<RestrictionEngine.ViewSpec>> collectRawForSkill(class_2960 skillId) {
                return RestrictionEngine.get().collectRestrictionsForSkill(skillId);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record Row(RowType type, int level, String text, class_1799 stack, List<class_1799> cycle) {
        static Row header(int lvl) {
            return new Row(RowType.HEADER, lvl, "Level " + lvl + ":", class_1799.field_8037, List.of());
        }

        static Row item(int lvl, class_1799 st) {
            return new Row(RowType.ITEM, lvl, null, st, List.of());
        }

        static Row rotate(int lvl, List<class_1799> stacks) {
            return new Row(RowType.ROTATE, lvl, null, class_1799.field_8037, stacks);
        }

        static Row tag(int lvl, String txt) {
            return new Row(RowType.TAG, lvl, txt, class_1799.field_8037, List.of());
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static enum RowType {
        HEADER,
        ITEM,
        ROTATE,
        TAG;

    }
}

