/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class RpgGeneralConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static RpgGeneralConfig INSTANCE;
    public Benefits benefits = new Benefits();
    public Xp xp = new Xp();

    private RpgGeneralConfig() {
    }

    public static RpgGeneralConfig get() {
        if (INSTANCE == null) {
            INSTANCE = new RpgGeneralConfig();
        }
        return INSTANCE;
    }

    public static void loadOrCreate(Path baseConfigDir) throws IOException {
        RpgGeneralConfig cfg;
        Path dir = baseConfigDir.resolve("rpglevel");
        Files.createDirectories(dir, new FileAttribute[0]);
        Path file = dir.resolve("general.json");
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(file);){
                cfg = (RpgGeneralConfig)GSON.fromJson((Reader)r, RpgGeneralConfig.class);
            }
        }
        cfg = new RpgGeneralConfig();
        try (BufferedWriter w = Files.newBufferedWriter(file, new OpenOption[0]);){
            GSON.toJson((Object)cfg, (Appendable)w);
        }
        if (cfg.benefits == null) {
            cfg.benefits = new Benefits();
        }
        if (cfg.xp == null) {
            cfg.xp = new Xp();
        }
        INSTANCE = cfg;
    }

    public static final class Benefits {
        public double enduranceExhaustionReductionMax = 1.0;
        public double combatDamageBonusMax = 4.0;
        public double archeryDamageBonusMax = 4.0;
        public double defenseMitigationMax = 0.9;
        public double miningSpeedBonusMax = 3.0;
        public double woodcuttingSpeedBonusMax = 3.0;
        public double farmingExtraDropChanceMax = 1.0;
        public double healingExtraHealthMax = 100.0;
    }

    public static final class Xp {
        public int farmingMatureCropXp = 5;
        public int woodcuttingPerLogXp = 3;
        public int miningPerBlockXp = 3;
        public int luckMiningEmeraldOreXp = 5;
        public int archeryUseBowXp = 1;
        public int combatRangedUseXp = 1;
        public int craftingDrinkPotionXp = 1;
        public int enduranceEatFoodXp = 1;
        public int craftingAnvilPerItemXp = 15;
        public int craftingSmithingPerItemXp = 15;
        public int craftingSmeltingFurnacePerItemXp = 10;
        public int craftingSmeltingSmokerPerItemXp = 20;
        public int craftingSmeltingBlastPerItemXp = 20;
        public int craftingBrewPotionPerBottleXp = 10;
        public double farmingHoeTillChance = 0.4;
        public int farmingHoeTillXp = 1;
        public int luckOpenLootContainerMin = 1;
        public int luckOpenLootContainerMax = 20;
        public int agilityPerSecondMovingXp = 1;
        public int endurancePerJumpXp = 1;
        public int fishingPerCatchMin = 3;
        public int fishingPerCatchMax = 12;
        public int defensePerDamageTakenDivisor = 4;
        public int combatPerDamageDealtDivisor = 6;
        public int luckEatGoldenAppleMin = 5;
        public int luckEatGoldenAppleMax = 30;
        public int luckEatEnchantedGoldenAppleMin = 30;
        public int luckEatEnchantedGoldenAppleMax = 180;
    }
}

