/*
 * Decompiled with CFR 0.152.
 */
package org.g_skyrim.rpglevel.network;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.g_skyrim.rpglevel.player.PlayerSkills;
import org.g_skyrim.rpglevel.skills.SkillDefinition;
import org.g_skyrim.rpglevel.skills.SkillRegistry;

public final class RpgNetwork {
    public static final class_2960 REQ_SNAPSHOT = new class_2960("rpglevel", "request_snapshot");
    public static final class_2960 SNAPSHOT = new class_2960("rpglevel", "skills_snapshot");
    public static final class_2960 INVEST = new class_2960("rpglevel", "invest_skill");

    private RpgNetwork() {
    }

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQ_SNAPSHOT, (server, player, handler, buf, responseSender) -> server.execute(() -> RpgNetwork.sendSnapshot(player)));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)INVEST, (server, player, handler, buf, responseSender) -> server.execute(() -> RpgNetwork.sendSnapshot(player)));
    }

    public static void sendSnapshot(class_3222 player) {
        PlayerSkills ps = PlayerSkills.of(player.method_5667());
        List<class_2960> ids = SkillRegistry.allIdsSnapshot();
        ids.sort(Comparator.comparing(class_2960::toString));
        class_2540 out = PacketByteBufs.create();
        out.method_10804(ps.getAvailablePoints());
        out.method_10804(ids.size());
        for (class_2960 id : ids) {
            int lvl = ps.getLevel(id);
            long xp = ps.getXp(id);
            SkillDefinition def = SkillRegistry.get(id).orElse(null);
            int max = def == null ? 0 : def.maxLevel();
            long prevReq = 0L;
            long nextReq = xp;
            if (def != null) {
                int L = Math.max(0, def.maxLevel() > 0 ? Math.min(lvl, def.maxLevel()) : lvl);
                Map.Entry<Integer, Long> floor = def.xpCurve().floorEntry(L);
                Map.Entry<Integer, Long> higher = def.xpCurve().higherEntry(L);
                long l = prevReq = floor != null ? floor.getValue() : 0L;
                if (higher != null) {
                    nextReq = higher.getValue();
                } else if (L >= max && max > 0) {
                    nextReq = prevReq;
                } else {
                    long diff;
                    Map.Entry<Integer, Long> beforeLast;
                    long step = 100L;
                    Map.Entry<Integer, Long> last = def.xpCurve().lastEntry();
                    if (last != null && (beforeLast = def.xpCurve().lowerEntry(last.getKey())) != null && (diff = last.getValue() - beforeLast.getValue()) > 0L) {
                        step = diff;
                    }
                    nextReq = prevReq + step;
                }
            }
            out.method_10812(id);
            out.method_10804(lvl);
            out.method_10791(xp);
            out.method_10804(max);
            out.method_10791(prevReq);
            out.method_10791(nextReq);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)SNAPSHOT, (class_2540)out);
    }
}

